let BASE_URL = ''
let TOKEN = null

const getCookie = (name: string): string | null => {
  const reg: RegExp = new RegExp(`(^| )${name}=([^;]*)(;|$)`)
  const arr: RegExpMatchArray | null = document.cookie.match(reg)
  if (arr) {
    return unescape(arr[2])
  }
  return null
}

switch (process.env.NODE_ENV) {
  case 'production':
    BASE_URL = 'https://survey.maicedata.com/public/api/data/'
    TOKEN = LZString.decompressFromEncodedURIComponent(
      getCookie('__DM_TOKEN__') || localStorage.get('dm_token_'),
    )
    break
  default:
    BASE_URL = 'https://survey.idatatlas.com/public/api/data/'
    TOKEN = '9f6ac66f-18bb-4f0c-930d-c8afa50d29ce'
}

export default {
  TOKEN,
  BASE_URL,
  ORGANIZATION: '733d0ac0-f67e-4bde-8872-3ca00983f18c',
  MEMBER: '6c18d1b6-406e-4961-965c-c4b9cfc14cc4',
  ACTIVITY: 'e6659af9-d53c-4b3f-9719-465d02687933',
  AREA: '65ef4ee6-4ad2-4754-b50c-1176c9188231',
  COMMITTEE: '6f610aca-39c2-4401-8b75-12f94193d956',
  COMMUNITY: '931687e6-b53a-4f2d-8ab9-83b4a7d5ea8f',
  STREET: 'af3ce0b6-f32d-4914-a336-bb7f6398ff85',
  BUIDING: 'e08e40c6-a15c-447d-8f9e-786216d93443',
}
