import { tokenIns } from '@/util/tokenUtil'

let BASE_URL: string = ''
let TOKEN: string = ''
let MAP_CONFIG: { jsApiUrl: string; cssUrl: string } = {
  jsApiUrl: '',
  cssUrl: '',
}

function getToken() {
  const header = window.__DM_GLOBE_UTIL
    ? window.__DM_GLOBE_UTIL.getHeader()
    : null
  return header ? header.authorization : tokenIns.get()
}

switch (process.env.NODE_ENV) {
  case 'production':
    BASE_URL = 'https://www.maicedata.com/collector/data/' // 生产环境
    TOKEN = getToken()
    MAP_CONFIG = {
      jsApiUrl: 'http://10.108.3.48/api418/arcgis_js_api/library/4.18/init.js',
      cssUrl:
        'http://10.108.3.48/api418/arcgis_js_api/library/4.18/esri/css/main.css',
    }
    break
  default:
    BASE_URL = '/api' // vite.config 代理 https://survey.maicedata.com/api/data/
    TOKEN = '91e315a9-b2a8-4950-97fa-9dbf84a230d6'
    MAP_CONFIG = {
      jsApiUrl: 'http://10.108.3.41/arcgis_js_api/library/4.18/init.js',
      cssUrl: 'http://10.108.3.41/arcgis_js_api/library/4.18/esri/css/main.css',
    }
  // MAP_CONFIG = {
  //   jsApiUrl: 'http://10.108.3.48/api418/arcgis_js_api/library/4.18/init.js',
  //   cssUrl:
  //     'http://10.108.3.48/api418/arcgis_js_api/library/4.18/esri/css/main.css',
  // }
}

export default {
  TOKEN,
  BASE_URL,
  MAP_CONFIG,
  ORGANIZATION: '733d0ac0-f67e-4bde-8872-3ca00983f18c',
  MEMBER: '6c18d1b6-406e-4961-965c-c4b9cfc14cc4',
  ACTIVITY: 'e6659af9-d53c-4b3f-9719-465d02687933',
  AREA: '65ef4ee6-4ad2-4754-b50c-1176c9188231',
  COMMITTEE: '6f610aca-39c2-4401-8b75-12f94193d956',
  COMMUNITY: '931687e6-b53a-4f2d-8ab9-83b4a7d5ea8f',
  STREET: 'af3ce0b6-f32d-4914-a336-bb7f6398ff85',
  BUILDING: 'e08e40c6-a15c-447d-8f9e-786216d93443',
  ROOM: '24b5403c-9b6e-4882-b049-51ef197e3aa7',
  ATTACHMENT: '988fc63e-fa55-4729-851d-24c4355213f2',
  TAG: '54344e11-c0d3-40d5-8f99-771066249328',
  GET_AUTH: '988fc63e-fa55-4729-851d-24c4355213f2/storage/grant',
  GET_USER_ID: 'https://www.maicedata.com/auth/user/bytoken',
  USER: '3625616b-7f2c-449a-8306-101aac7b8b97',
  ORG: 'b47ddc9a-0aa7-45a8-b1b6-6064f888d537',
  MENU: 'd64f4037-1a0c-4900-a8a1-80a7115e0995',
}
