import { organization, member } from '@/util/tags'
import switchOrgLevel from '@/util/switchOrgLevel'
import dayjs from 'dayjs'
// import useExportXlsx from '@/hooks/useExportXlsx'

const trans = (val: string) => {
  if (!val) return '无'
  return (val && val.replace(/(\w{3})\w*(\w{4})/, '$1******$2')) || '无'
}
const transAddress = (a: string, b: string, c: string) => {
  let result = ''
  a && (result += a)
  b && (result += b)
  c && (result += c)
  return result || '无'
}

const style = `
<style>
  .pop-container {
    border-radius: .04rem;
    box-sizing: border-box;
    padding: .1rem;
    width: 100%;
  }
  .title {
    font-size: .13rem;
    font-family: PingFangMedium, 'Avenir', Helvetica, Arial, sans-serif;
  }
  .tag-wrapper {
    display:flex;
    flex-wrap: wrap;
    margin: .05rem 0;
  }
  .tag {
    display: inline-block;
    border-radius: .04rem;
    font-size: .09rem;
    padding: .02rem .04rem;
    margin: 0 .05rem .05rem 0;
  }
  .tag.primary {
    color: #DD505E;
    background: #FCF4F5;
  }
  .tag.info {
    color: #3D7FE9;
    background: #ECEFFA;
  }
  .tag.success {
    color: #2BB480;
    background: #E9F7F0;
  }
  .tag.warning {
    color: #E59B00;
    background: #FFF4E6;
  }
  .tag.error {
    color: #AC60CA;
    background: #F5F0F9;
  }
  .flex,
  .box {
    background: #fcfcfc;
    border-radius: .03rem;
    margin-top: .05rem;
    box-sizing: border-box;
    padding: .1rem;
  }
  .flex {
    display: flex;
    flex-wrap: wrap;
  }
  .box > .inline {
    display: flex;
    align-items: center;
  }
  .box > .inline > span {
    width: 25%;
    white-space: nowrap;
  }
  .flex > div {
    margin-right: .05rem;
  }
  .flex > div:nth-of-type(1),
  .flex > div:nth-of-type(3),
  .flex > div:nth-of-type(4) {
    width: 25%;
  }
  .flex > div:nth-of-type(2),
  .flex > div:nth-of-type(5) {
    width: 40%;
  }
  .flex span,
  .box span {
    color: rgba(0,0,0,.6);
  }
  .flex p,
  .box p {
    margin-bottom: .03rem;
    font-family: PingFangMedium, 'Avenir', Helvetica, Arial, sans-serif;
  }
  .flex img,
  .box img {
    width: 25%;
  }
  .pop-container .wrapper {
    max-height: 50vh;
    padding-bottom: .1rem;
    margin-top: .05rem;
    // overflow-y:auto;
    border-top: .01rem solid rgba(0,0,0,.06);
  }
  .pop-container .wrapper > .item {
    border-radius: .03rem;
    position: relative;
    background: transparent;
    cursor: pointer;
    box-sizing: border-box;
    padding: .05rem .08rem;
  }
  .pop-container .wrapper > .item:hover {
    background: #FCF4F5;
  }
  .pop-container .wrapper > .item p,
  .pop-container .wrapper > .item span {
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    font-size: .1rem;
  }
  .pop-container .wrapper > .item p {
    font-family: PingFangMedium, 'Avenir', Helvetica, Arial, sans-serif;
  }
  .pop-container .wrapper > .item span {
    color: rgba(0,0,0,.6);
  }
</style>
`
const getOrgTags = (tags: string) => {
  if (!tags || !tags.split) return ''
  return `
    <div class="tag-wrapper">
      ${tags
        .split(',')
        .map(
          (tag: string) => `
          <span class="tag ${
            organization.find((e) => e.name === tag)?.type
          }">${tag}</span>
        `,
        )
        .join('')}
    </div>
  `
}
const getMemberTags = (tags: string[]) => {
  if (!tags || tags.length === 0) return ''
  return `
    <div class="tag-wrapper">
      ${tags
        .map(
          (tag: string) => `
          <span class="tag ${
            member.find((e) => e.name === tag)?.type
          }">${tag}</span>
        `,
        )
        .join('')}
    </div>
  `
}

export const transOrgHtml = (data: any) => {
  return `
    ${style}
    <div class="pop-container">
      <p class="title">${data?.['党组织名称']}</p>
      ${getOrgTags(data?.['标签'])}
      <p>${data['党组织地址']}</p>
      <div class="flex">
        <div>
          <span>${switchOrgLevel(data, '书记')}</span>
          <p>${data['书记']}</p>
        </div>
        <div>
          <span>党员数量</span>
          <p>${data['党员数量'] || '无'}</p>
        </div>
      </div>
      <div class="box">
        <div>
          <span>${switchOrgLevel(data, '副书记')}</span>
          <p>${data['副书记'] || '无'}</p>
        </div>
        <div>
          <span>上级党组织名称</span>
          <p>${data['上级党组织名称'] || '无'}</p>
        </div>
        <div>
          <span>联系电话</span>
          <p>${trans(data['联系方式_座机'] || data['联系方式_手机'])}</p>
        </div>
      </div>
    </div>
    `
}

export const transMemberHtml = (data: any) => {
  return `
    ${style}
    <div class="pop-container">
      <p class="title">${data['姓名']}</p>
      ${getMemberTags(data?.['标签'])}
      <p>${data['所属党组织名称']}</p>
      <div class="flex">
        <div>
          <span>性别</span>
          <p>${data['性别']}</p>
        </div>
        <div>
          <span>出生日期</span>
          <p>${dayjs(data['出生日期']).format('ll')}</p>
        </div>
        <div>
          <span>学历</span>
          <p>${data['学历'] || '无'}</p>
        </div>
        <div>
          <span>党员身份</span>
          <p>${data['党员身份']}</p>
        </div>
        <div>
          <span>入党日期</span>
          <p>${dayjs(data['加入中共党组织日期']).format('ll')}</p>
        </div>
      </div>
      <div class="box">
        <div>
          <span>身份证号码</span>
          <p>${trans(data['身份证号码'])}</p>
        </div>
        <div>
          <span>居住地址</span>
          <p>${transAddress(
            data['所属小区'],
            data['所属楼宇'],
            data['所属房间'],
          )}</p>
        </div>
        <div>
          <span>联系电话</span>
          <p>${trans(data['联系方式_手机'])}</p>
        </div>
      </div>
    </div>
  `
}

export const transActivityHtml = (data: any) => {
  // const mock = [
  //   {
  //     出席率: 67,
  //     标签类别: '主题党日活动',
  //     活动名称: '牡丹活动',
  //     活动地址:
  //       '中共浦东新区花木街道牡丹社区第一居民区第一支部委员会中共浦东新区花木街道牡丹社区第一居民区第一支部委员会',
  //     活动日期: 1632240000,
  //     党组织名称: '中共浦东新区花木街道牡丹社区第一居民区第一支部委员会',
  //     党组织编号: '001.001.031.014.205.002.001.601.701',
  //     签到表照片: [],
  //     上海2000纬度: -2581.95914975792,
  //     上海2000经度: 7037.33995731356,
  //     台账记录照片: [],
  //     实际参与人数: 40,
  //     活动内容描述: '描述',
  //     不计入参与活动党员人数: 3,
  //   },
  // ]

  return `
    ${style}
    <div class="pop-container">
      <p class="title">${data['活动名称']}</p>
      <p>${data['党组织名称']}</p>
      <div class="wrapper">
        <div class="box inline">
          <div>
            <span>活动日期：</span>
            <p>${dayjs(+(data['活动日期'] + '000')).format('ll')}</p>
          </div>
          <div>
            <span>活动地址：</span>
            <p>${data['活动地址']}</p>
          </div>
          <div>
            <span>参与人数：</span>
            <p>${data['实际参与人数']}人</p>
          </div>
          <div>
            <span>出席率：</span>
            <p>${data['出席率']}%</p>
          </div>
        </div>
        <div class="box">
          <div>
            <span>活动内容描述</span>
            <p>${data['活动内容描述'] || '无'}</p>
          </div>
        </div>
        <div class="box">
          <div>
            <span>活动照片</span>
            <p>${(data?.['活动照片'] || [])
              ?.map((item) => `<img src="${item}"/>`)
              ?.join('')}</p>
          </div>
        </div>
      </div>
    </div>
  `
}

export const transListHtml = (data: any) => {
  const { list } = data
  let pointName = '数据'
  if (list[0]['活动名称']) {
    pointName = '活动'
  } else if (list[0]['党组织名称']) {
    pointName = '党组织'
  } else if (list[0]['姓名']) {
    pointName = '党员'
  }
  const template = (data: any) => {
    switch (pointName) {
      case '活动':
        return `<p class=${'title'}>${data['活动名称']}</p><p>${
          data['党组织名称']
        }</p><div class=${'wrapper'}><div class=${'box'}><div class=${'inline'}><span>活动日期：</span><p>${dayjs(
          +(data['活动日期'] + '000'),
        ).format(
          'll',
        )}</p></div><div class=${'inline'}><span>活动地址：</span><p>${
          data['活动地址']
        }</p></div><div class=${'inline'}><span>参与人数：</span><p>${
          data['实际参与人数']
        }人</p></div><div class=${'inline'}><span>出席率：</span><p>${
          data['出席率']
        }%</p></div></div><div class=${'box'}><div><span>活动内容描述</span><p>${
          data['活动内容描述'] || '无'
        }</p></div></div><div class=${'box'}><div><span>活动照片</span><p>${(
          data?.['活动照片'] || []
        )
          ?.map((e) => `<img src=${e}>`)
          ?.join('')}</p></div></div></div>`
      case '党组织':
        return `<p class=${'title'}>${data?.['党组织名称']}</p>${getOrgTags(
          data?.['标签'],
        )}<p>${
          data['党组织地址']
        }</p><div class=${'flex'}"><div><span>${switchOrgLevel(
          data,
          '书记',
        )}</span><p>${data['书记']}</p></div><div><span>党员数量</span><p>${
          data['党员数量'] || '无'
        }</p></div></div><div class=${'box'}><div><span>${switchOrgLevel(
          data,
          '副书记',
        )}</span><p>${
          data['副书记'] || '无'
        }</p></div><div><span>上级党组织名称</span><p>${
          data['上级党组织名称'] || '无'
        }</p></div><div><span>联系电话</span><p>${trans(
          data['联系方式_座机'] || data['联系方式_手机'],
        )}</p></div></div>`
      case '党员':
        return `<p class=${'title'}>${data['姓名']}</p>${getMemberTags(
          data?.['标签'],
        )}<p>${
          data['所属党组织名称']
        }</p><div class=${'flex'}><div><span>性别</span><p>${
          data['性别']
        }</p></div><div><span>出生日期</span><p>${dayjs(
          data['出生日期'],
        ).format('ll')}</p></div><div><span>学历</span><p>${
          data['学历'] || '无'
        }</p></div><div><span>党员身份</span><p>${
          data['党员身份']
        }</p></div><div><span>入党日期</span><p>${dayjs(
          data['加入中共党组织日期'],
        ).format(
          'll',
        )}</p></div></div><div class=${'box'}><div><span>身份证号码</span><p>${trans(
          data['身份证号码'],
        )}</p></div><div><span>居住地址</span><p>${transAddress(
          data['所属小区'],
          data['所属楼宇'],
          data['所属房间'],
        )}</p></div><div><span>联系电话</span><p>${trans(
          data['联系方式_手机'],
        )}</p></div></div>`
      default:
        break
    }
  }
  return `
    ${style}
      <div class="pop-container">
        <p class="title">此处${list.length}个${pointName}</p>
        <div class="wrapper">
          ${list
            .map(
              (
                item: any,
              ) => `<div class="item" onclick="(function(){document.querySelector('.pop-container').innerHTML = '${template(
                item,
              )}'})()">
              <p>${item['活动名称'] || item['党组织名称'] || item['姓名']}</p>
              <span>${
                item['活动地址'] ||
                item['党组织地址'] ||
                item['所属党组织名称'] ||
                '无'
              }</span>
            </div>
          `,
            )
            .join('')}
        </div>
      </div>
    `
}
