import { ajax, api } from '@/ajax'
interface QueryProps {
  a?: string
  q?: string
  keys?: string
  [key: string]: unknown
}

export async function useFetchOrg(params: QueryProps) {
  const res = await ajax.get({
    url: api.ORGANIZATION,
    params,
  })
  return res && res.data && res.data.result
}

export async function useFetchMember(params: QueryProps) {
  const res = await ajax.get({
    url: api.MEMBER,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchActivity(params: QueryProps) {
  const res = await ajax.get({
    url: api.ACTIVITY,
    params,
  })
  return res && res.data && res.data.result
}
export async function usePostActivity(params: QueryProps) {
  const res = await ajax.post({
    url: api.ACTIVITY,
    params,
  })
  return res && res.data && res.data.result
}
export async function usePutActivity(params: QueryProps) {
  const res = await ajax.put({
    url: api.ACTIVITY,
    params,
  })
  return res && res.data && res.data.result
}
export async function useDeleteActivity(params: QueryProps) {
  const res = await ajax.delete({
    url: api.ACTIVITY,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchArea(params: QueryProps) {
  const res = await ajax.get({
    url: api.AREA,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchCommittee(params: QueryProps) {
  const res = await ajax.get({
    url: api.COMMITTEE,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchCommunity(params: QueryProps) {
  const res = await ajax.get({
    url: api.COMMUNITY,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchStreet(params: QueryProps) {
  const res = await ajax.get({
    url: api.STREET,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchBuilding(params: QueryProps) {
  const res = await ajax.get({
    url: api.BUILDING,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchRoom(params: QueryProps) {
  const res = await ajax.get({
    url: api.ROOM,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchAttachment(params: QueryProps) {
  const res = await ajax.get({
    url: api.ATTACHMENT,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchTag(params: QueryProps) {
  const res = await ajax.get({
    url: api.TAG,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchAuth() {
  const res = await ajax.get({
    url: api.GET_AUTH,
  })
  return res && res.data && res.data.result
}
