import useJsApi from '@/hooks/useJsApi'

export default {
  async displayJSONData(layerName: string, Parameters: { result: any[] }) {
    if (!Parameters.result || Parameters.result.length === 0) return
    const [
      LabelClass,
      Graphic,
      Point,
      Polyline,
      Polygon,
      SpatialReference,
      FeatureLayer,
      Legend,
    ] = await useJsApi([
      'esri/layers/support/LabelClass',
      'esri/Graphic',
      'esri/geometry/Point',
      'esri/geometry/Polyline',
      'esri/geometry/Polygon',
      'esri/geometry/SpatialReference',
      'esri/layers/FeatureLayer',
      'esri/widgets/Legend',
    ])

    let clientOperateLayer
    const geometryType = 'point'
    console.log('落点数据', Parameters.result)
    const graphicSource = Parameters.result.map((item: any) => {
      const point = new Point({
        x: item['上海2000经度'],
        y: item['上海2000纬度'],
        spatialReference: SpatialReference.WebMercator,
      })
      return new Graphic({
        geometry: point,
        attributes: {
          ...item,
          json: JSON.stringify(item),
        },
      })
    })
    const renderer = {
      type: 'simple', // autocasts as new SimpleRenderer()
      symbol: {
        type: 'point-3d', // autocasts as new PointSymbol3D()
        symbolLayers: [
          {
            type: 'icon', // autocasts as new IconSymbol3DLayer()
            resource: {
              primitive: 'circle',
            },
            material: {
              color: '#dd505e',
            },
            size: 8,
            outline: {
              color: 'white',
              size: 1,
            },
          },
        ],
        verticalOffset: {
          screenLength: 40,
          maxWorldLength: 200,
          minWorldLength: 35,
        },
        // callout: {
        //   type: "line", // autocasts as new LineCallout3D()
        //   // color: "#659def",
        //   color: "#fff",
        //   size: 2,
        //   border: {
        //     // color: [192, 196, 204]
        //     color: "#659def"
        //   }
        // }
      }, // autocasts as new SimpleFillSymbol()
    }

    const statesLabelClass = new LabelClass({
      labelExpressionInfo: {
        expression: '$feature["_labelKey"]', // label取值
      },
      symbol: {
        type: 'text',
        color: '#fff',
        font: {
          size: 12,
          // weight: "bold"
        },
        haloSize: 2,
        haloColor: '#dd505e',
      },
      labelPlacement: 'above-center',
    })

    const fields = [
      {
        name: 'OBJECTID',
        alias: 'OBJECTID',
        type: 'oid',
      },
      {
        name: 'json',
        alias: 'json',
        type: 'string',
      },
    ]

    Object.keys(Parameters.result[0]).forEach((item) => {
      const field = {
        name: item,
        alias: item,
        type: Array.isArray(item) ? 'array' : 'string',
      }
      fields.push(field)
    })

    clientOperateLayer = window.map.findLayerById(layerName)
    if (!clientOperateLayer) {
      clientOperateLayer = new FeatureLayer({
        id: layerName,
        title: layerName,
        outFields: ['*'],
        objectIdField: 'OBJECTID',
        geometryType,
        renderer: renderer,
        labelingInfo: [statesLabelClass],
        screenSizePerspectiveEnabled: false,
        // popupEnabled: true,
        // popupTemplate: {
        //   title: '{name}',
        //   content: [{
        //     type: 'fields',
        //     fieldInfos: [{
        //         fieldName: '党组织名称',
        //         label: '党组织名称',
        //       },
        //       {
        //         fieldName: '党组织地址',
        //         label: '党组织地址',
        //       },
        //     ],
        //   }, ],
        // },
        // popupTemplate: Parameters.popupTemplate,
        fields: fields,
        // featureReduction: {
        //   type: 'selection',
        // },
        // elevationInfo: Parameters.elevationInfo,
        spatialReference: SpatialReference.WebMercator,
      })
      window.map.add(clientOperateLayer)
      if (!window.pointLayers) {
        window.pointLayers = []
      }
      window.pointLayers.push(clientOperateLayer)
    } else {
      //  clientOperateLayer.source = null;
      // clientOperateLayer.refresh();
    }

    clientOperateLayer.source = graphicSource
    clientOperateLayer.visible = true
    clientOperateLayer.refresh()
  },
}
