let BASE_URL = ''
let TOKEN = null

const getCookie = (name: string): string | null => {
  const reg: RegExp = new RegExp(`(^| )${name}=([^;]*)(;|$)`)
  const arr: RegExpMatchArray | null = document.cookie.match(reg)
  if (arr) {
    return unescape(arr[2])
  }
  return null
}

switch (process.env.NODE_ENV) {
  case 'production':
    BASE_URL = ''
    TOKEN = getCookie('__DM_TOKEN__') || localStorage.get('dm_token_')
    break
  default:
    BASE_URL = ''
    TOKEN = 'EwNgRgHMCsAsYFoDMIAMEG1U2CCcAZnkggIakCmAJiNNgOxIDGVQA'
}

export default {
  TOKEN,
  BASE_URL,

  /**
   * 党员详情
   * @param memberId 必须
   */
  GET_MEMBER_INFO: '/base/memberInfo',

  /**
   * 党组织详情
   * @param orgId 必须
   */
  GET_ORG_INFO: '/base/orgInfo',

  /**
   * 党组织分类
   * @param organizationId   | 否   |      | 党组织唯一识别标识，确定本次查询是全街道、某一个组织下。没有默认全街道 |
   * @param areaID           | 否   |      | 社区ID，默认不指定社区                                       |
   * @param labelForOrg      | 否   |      | 组织标签，可多个，多个','拼接，默认无筛选标签                |
   * @param labelForMemberIn | 否   |      | 党员标签，可多个，多个','拼接，默认无筛选标签                |
   * @param residentsID      | 否   |      | 社区ID，默认不指定居委                                       |
   * @param communityID      | 否   |      | 小区ID，默认不指定小区                                       |
   * @param buildingID       | 否   |      | 楼栋ID，默认不指定楼栋                                       |
   * @param organizationType | 否   |      | 党组类型（机关事业单位、居民区、两新），单选，默认无类型标签 |
   */
  GET_ORG_TYPE: '/base/distribution/orgType',

  /**
   * 关系在街道党员年龄分布
   * @param organizationId   | 否   |      | 党组织唯一识别标识，确定本次查询是全街道、某一个组织下。没有默认全街道 |
   * @param areaID           | 否   |      | 社区ID，默认不指定社区                                       |
   * @param labelForOrg      | 否   |      | 组织标签，可多个，多个','拼接，默认无筛选标签                |
   * @param labelForMemberIn | 否   |      | 党员标签，可多个，多个','拼接，默认无筛选标签                |
   * @param residentsID      | 否   |      | 社区ID，默认不指定居委                                       |
   * @param communityID      | 否   |      | 小区ID，默认不指定小区                                       |
   * @param buildingID       | 否   |      | 楼栋ID，默认不指定楼栋                                       |
   * @param organizationType | 否   |      | 党组类型（机关事业单位、居民区、两新），单选，默认无类型标签 |
   */
  GET_MEMBER_AGE: '/base/distribution/age',

  /**
   * 关系在街道党员分类
   * @param organizationId   | 否   |      | 党组织唯一识别标识，确定本次查询是全街道、某一个组织下。没有默认全街道 |
   * @param areaID           | 否   |      | 社区ID，默认不指定社区                                       |
   * @param labelForOrg      | 否   |      | 组织标签，可多个，多个','拼接，默认无筛选标签                |
   * @param labelForMemberIn | 否   |      | 党员标签，可多个，多个','拼接，默认无筛选标签                |
   * @param residentsID      | 否   |      | 社区ID，默认不指定居委                                       |
   * @param communityID      | 否   |      | 小区ID，默认不指定小区                                       |
   * @param buildingID       | 否   |      | 楼栋ID，默认不指定楼栋                                       |
   * @param organizationType | 否   |      | 党组类型（机关事业单位、居民区、两新），单选，默认无类型标签 |
   */
  GET_MEMBER_TYPE: '/base/distribution/relation',

  /**
   * 基本情况统计
   * @param organizationId   | 否   |      | 党组织唯一识别标识，确定本次查询是全街道、某一个组织下。没有默认全街道 |
   * @param areaID           | 否   |      | 社区ID，默认不指定社区                                       |
   * @param labelForOrg      | 否   |      | 组织标签，可多个，多个','拼接，默认无筛选标签                |
   * @param labelForMemberIn | 否   |      | 党员标签，可多个，多个','拼接，默认无筛选标签                |
   * @param residentsID      | 否   |      | 社区ID，默认不指定居委                                       |
   * @param communityID      | 否   |      | 小区ID，默认不指定小区                                       |
   * @param buildingID       | 否   |      | 楼栋ID，默认不指定楼栋                                       |
   * @param organizationType | 否   |      | 党组类型（机关事业单位、居民区、两新），单选，默认无类型标签 |
   */
  GET_BASIC_INFO: '/base/totalCount',

  /**
   * 按组织类型获取党组织GIS对象，含点位（组织搜索选中撒点、地理筛选撒点、组织类型切换撒点)
   * @param organizationId   | 否   |      | 党组织唯一识别标识，确定本次查询是全街道、某一个组织下。没有默认全街道 |
   * @param areaID           | 否   |      | 社区ID，默认不指定社区                                       |
   * @param labelForOrg      | 否   |      | 组织标签，可多个，多个','拼接，默认无筛选标签                |
   * @param residentsID      | 否   |      | 社区ID，默认不指定居委                                       |
   * @param communityID      | 否   |      | 小区ID，默认不指定小区                                       |
   * @param buildingID       | 否   |      | 楼栋ID，默认不指定楼栋                                       |
   * @param organizationType | 否   |      | 党组类型（机关事业单位、居民区、两新），单选，默认无类型标签 |
   * @param pageSize         | 是   |      | 分页数                                                       |
   * @param pageNo           | 是   |      | 页码                                                         |
   */
  GET_ORG_GIS: '/gis/org',

  /**
   * 获取党员GIS对象，含点位（党员搜索选中撒点、标签筛选撒点）
   * @param labelForMemberIn | 否   |      | 党员标签，可多个，多个','拼接，默认无筛选标签 |
   * @param memberId         | 否   |      | 需要定位的党员ID                              |
   * @param pageSize         | 是   |      | 分页数                                        |
   * @param pageNo           | 是   |      | 页码                                          |
   */
  GET_MEMBER_GIS: '/gis/member',

  /**
   * 获取活动GIS对象，含点位（党组活动撒点）
   * @param activityTypeIds |是 |        |活动分类，可多个，多个','拼接
   */
  GET_ACTIVITY_GIS: '/gis/activity',

  /**
   * 党员搜索
   * @param name     | 是   |      | 模糊搜索 |
   * @param pageSize | 是   |      |          |
   * @param pageNo   | 是   |      |          |
   */
  SEARCH_MEMBER: '/search/member',

  /**
   * 党组织搜索
   * @param name     | 是   |      | 模糊搜索 |
   * @param pageSize | 是   |      |          |
   * @param pageNo   | 是   |      |          |
   */
  SEARCH_ORG: '/search/org',

  /**
   * 综合搜索
   * @param name     | 是   |      | 模糊搜索 |
   */
  SEARCH_ALL: '/search/all',

  /**
   * 下载指定标签文件
   * @param labelType | 是   |      | 党组标签，或 党员标签 |
   * @param labelId   | 是   |      |                       |
   */
  GET_TAG_FILE: '/filter/label/getfile',

  /**
   * 获取全部标签
   */
  GET_ALL_TAG: '/filter/label/all',

  /**
   * 获取指定小区下所有楼栋
   * @param areaId      | 是   |      | 社区id |
   * @param residentId  | 是   |      | 居委Id |
   * @param communityId | 是   |      | 小区id |
   */
  GET_BUILDING: '/filter/building/all',

  /**
   * 获取指定居委下所有小区
   * @param areaId     | 是   |      | 社区id |
   * @param residentId | 是   |      | 居委Id |
   */
  GET_COMMUNITY: '/filter/community/all',

  /**
   * 获取指定楼栋下所有分户结构
   * @param areaId      | 是   |      | 社区id |
   * @param residentId  | 是   |      | 居委Id |
   * @param communityId | 是   |      | 小区id |
   * @param buildingId  | 是   |      | 楼栋id |
   */
  GET_HOUSE: '/filter/house/all',

  /**
   * 获取指定社区下所有居委清单
   * @param areaId      | 是   |      | 社区id |
   */
  GET_COMMITTEE: '/filter/resident/all',

  /**
   * 获取社区清单
   */
  GET_AREA: '/filter/area/all',

  /**
   * 修改活动
   * Content-Type=application/json
   * body = {
      activityId: '542180348126879744', // 活动Id
      activityName: '542180348126879744', // 活动名称
      orgId: '542180348126879744', //所属党组织ID
      orgName: '542180348126879744', //所属党组织名称
      activityDate: '542180348126879744', //活动开始时间
      activityAddress: '542180348126879744', //活动地址
      personActNum: '542180348126879744', //活动参与人数
      personIgAll: '542180348126879744', //活动hulve人数
      personAll: '542180348126879744', //活动总人数
      present: '542180348126879744', //出席率
      presentFile: {
        //出勤记录文件
        fileID: '',
        fileType: 'photo / file',
      },
      content: '542180348126879744',
      contentFile: {
        //活动台账记录文件
        fileID: '',
        fileType: 'photo / file',
      },
      photos: [
        {
          // 活动照片
          fileID: '',
          fileType: 'photo / file',
        },
        {
          fileID: '',
          fileType: 'photo / file',
        },
      ],
      creatorID: null, // 创建者id
    }
   */
  PUT_ACTIVITY: '/activity',

  /**
   * 删除活动
   * Content-Type=application/json
   * body = {
      activityId: '542180348126879744', // 活动Id
    }
   */
  DELETE_ACTIVITY: '/activity',

  /**
   * 新增活动
   * Content-Type=application/json
   * 参数同PUT_ACTIVITY
   */
  POST_ACTIVITY: '/activity',

  /**
   * 活动分类筛选
   * @param startDate | 否       |      | 起始日期 |
   * @param endDate   | 否       |      | 截止日期 |
   */
  GET_ACTIVITY_TYPE: '/activityType/filter',

  /**
   * 活动列表
   * @param startDate      | 否       |      | 起始日期   |
   * @param endDate        | 否       |      | 截止日期   |
   * @param activityTypeId | 否       |      | 活动类型ID |
   * @param presetS        | 否       |      | 最低出席率 |
   * @param presetE        | 否       |      | 最高出席率 |
   * @param pageSize       | 是       |      |            |
   * @param pageNo         | 是       |      |            |
   */
  GET_ACTIVITY: '/activities',

  /**
   * 活动详情
   * @param activityId | 是       |      | 活动id |
   */
  GET_ACTIVITY_INFO: '/activity/info',

  /**
   * 获取活动文档导出地址
   * @param activityId | 是       |      | 活动id |
   */
  GET_ACTIVITY_FILE: '/activity/downloadUrl',

  /**
   * 上传文件
   * Content-Type=multipart/form-data
   * @param file     | file     | 是       |      |      |
   */
  POST_FILE: '/file/upload',
}
