import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import vueJsx from '@vitejs/plugin-vue-jsx'
import { resolve } from 'path'
import svgicon from 'vite-plugin-svgicon'

export default defineConfig({
  base: './',
  plugins: [
    vue(),
    vueJsx(),
    svgicon({
      include: ['**/images/**/*.svg'],
    }),
  ],
  resolve: {
    alias: {
      '@': resolve(__dirname, './src'),
      '@images': resolve(__dirname, './src/assets/images'),
    },
  },
  server: {
    proxy: {
      '/api': {
        target: 'https://survey.maicedata.com/api/data/',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, ''),
      },
    },
  },
  base: '/statics/huamu_party_building_3d',
})
