import { tokenIns } from '@/util/tokenUtil'
import { getCookie } from '@/util/cookieUtil'
let BASE_URL: string = ''
let MAP_CONFIG: { jsApiUrl: string; cssUrl: string } = {
  jsApiUrl: '',
  cssUrl: '',
}
let MAP_URL: string = ''
let TOKEN: string = ''

const mdtUser = getCookie('__DM_MDT_USER__')
const imperToken = getCookie('__DM_IMPER_TOKEN__')
const imperMdtUser = getCookie('__DM_IMPER_MDT_USER__')

switch (process.env.NODE_ENV) {
  case 'production': // 生产环境
    BASE_URL = 'https://www.maicedata.com/collector/data/'
    TOKEN = tokenIns.get()
    MAP_CONFIG = {
      jsApiUrl:
        'https://hm.metrodata.cn/cehuiyuan/api418/arcgis_js_api/library/4.18/init.js',
      cssUrl:
        'https://hm.metrodata.cn/cehuiyuan/api418/arcgis_js_api/library/4.18/esri/css/main.css',
    }
    MAP_URL = 'https://hm.metrodata.cn/cehuiyuan'
    break
  case 'sit': // 测试环境（暂时部署在测绘院用）
    BASE_URL = 'https://www.maicedata.com/collector/data/'
    TOKEN = '8d979525-f8ab-4c62-9d6b-a6eeb62c7455'
    MAP_CONFIG = {
      jsApiUrl: 'http://10.108.3.41/arcgis_js_api/library/4.18/init.js',
      cssUrl: 'http://10.108.3.41/arcgis_js_api/library/4.18/esri/css/main.css',
    }
    MAP_URL = 'http://10.108.3.48'
    break
  default:
    // 本地开发环境
    BASE_URL = '/api' // 由 vite.config 代理
    TOKEN = 'c0c4003b-9b3a-4daf-8363-5707ee891255'
    MAP_CONFIG = {
      jsApiUrl: 'http://10.108.3.41/arcgis_js_api/library/4.18/init.js',
      cssUrl: 'http://10.108.3.41/arcgis_js_api/library/4.18/esri/css/main.css',
    }
    MAP_URL = 'http://10.108.3.48'
}
export default {
  TOKEN,
  mdtUser,
  imperToken,
  imperMdtUser,
  BASE_URL,
  MAP_CONFIG,
  MAP_URL,
  ORGANIZATION: '733d0ac0-f67e-4bde-8872-3ca00983f18c',
  MEMBER: '6c18d1b6-406e-4961-965c-c4b9cfc14cc4',
  ACTIVITY: 'e6659af9-d53c-4b3f-9719-465d02687933',
  AREA: '65ef4ee6-4ad2-4754-b50c-1176c9188231',
  COMMITTEE: '6f610aca-39c2-4401-8b75-12f94193d956',
  COMMUNITY: '931687e6-b53a-4f2d-8ab9-83b4a7d5ea8f',
  STREET: 'af3ce0b6-f32d-4914-a336-bb7f6398ff85',
  BUILDING: 'e08e40c6-a15c-447d-8f9e-786216d93443',
  ROOM: '24b5403c-9b6e-4882-b049-51ef197e3aa7',
  ATTACHMENT: '988fc63e-fa55-4729-851d-24c4355213f2',
  TAG: '54344e11-c0d3-40d5-8f99-771066249328',
  GET_AUTH: '988fc63e-fa55-4729-851d-24c4355213f2/storage/grant',
  GET_USER_ID: 'https://www.maicedata.com/auth/user/bytoken',
  USER: 'add27775-bbe7-4303-b38a-06b4e3cd88d3',
  ORG: 'b70f4cca-d7c2-499f-9ccd-243d205847d6',
  MENU: 'd64f4037-1a0c-4900-a8a1-80a7115e0995',
}
