export default function useDebounce<F extends Function>(
  func: F,
  interval: number = 300,
): F {
  let timer: number

  return <any>function (this: any, ...args: any[]) {
    if (timer) {
      window.clearTimeout(timer)
    }
    const context = this
    timer = window.setTimeout(function () {
      func.apply(context, args)
    }, interval)
  }
}
