import { createApp } from 'vue'
import App from './App.vue'
import MyComponent from '@/components/MyComponent'
import { VueSvgIconPlugin } from '@yzfe/vue3-svgicon'
import '@yzfe/svgicon/lib/svgicon.css'

import {
  create,
  NSpace,
  NInput,
  NDropdown,
  NIcon,
  NCollapse,
  NCollapseItem,
  NTabs,
  NTabPane,
  NEmpty,
  NButton,
  NDrawer,
  NDrawerContent,
  NCheckbox,
  NDatePicker,
  NSwitch,
  NInputNumber,
  NCarousel,
} from 'naive-ui'

const naive = create({
  components: [
    NSpace,
    NInput,
    NDropdown,
    NIcon,
    NCollapse,
    NCollapseItem,
    NTabs,
    NTabPane,
    NEmpty,
    NButton,
    NDrawer,
    NDrawerContent,
    NCheckbox,
    NDatePicker,
    NSwitch,
    NInputNumber,
    NCarousel,
  ],
})

createApp(App)
  .use(MyComponent)
  .use(naive)
  .use(VueSvgIconPlugin, {
    tagName: 'svg-icon',
  })
  .mount('#app')
