import IatRecorder from '@/util/iat-recorder'
import { onBeforeUnmount, ref } from 'vue'

type Status = 'init' | 'ing' | 'end'
export default function useVoiceRecorder() {
  const iatRecorder: any = new IatRecorder()
  const result = ref('')
  const status = ref<Status>('init')
  const timer: any = null

  iatRecorder.onTextChange = function (txt: string) {
    result.value = txt
  }
  iatRecorder.onWillStatusChange = function (_, curStatus: Status) {
    status.value = curStatus
    // let seconds = 0
    // if (curStatus === 'ing') {
    // timer = setInterval(() => {
    //   seconds += 1
    //   if (seconds >= 60) {
    //     iatRecorder.stop()
    //     clearInterval(timer)
    //   }
    // }, 1000)
    // }
  }
  onBeforeUnmount(() => {
    iatRecorder.stop()
    timer && clearInterval(timer)
  })

  function toggleRecorder() {
    if (iatRecorder.status === 'ing') {
      iatRecorder.stop()
    } else {
      iatRecorder.start()
    }
  }

  function reset() {
    iatRecorder.stop()
    iatRecorder.status === 'init'
    status.value = 'init'
    result.value = ''
  }

  return { result, toggleRecorder, status, reset }
}
