let BASE_URL = ''
let TOKEN = null

const getCookie = (name: string): string | null => {
  const reg: RegExp = new RegExp(`(^| )${name}=([^;]*)(;|$)`)
  const arr: RegExpMatchArray | null = document.cookie.match(reg)
  if (arr) {
    return unescape(arr[2])
  }
  return null
}

switch (process.env.NODE_ENV) {
  case 'production':
    BASE_URL = ''
    TOKEN = getCookie('__DM_TOKEN__') || localStorage.get('dm_token_')
    break
  default:
    BASE_URL = ''
    TOKEN = 'EwNgRgHMCsAsYFoDMIAMEG1U2CCcAZnkggIakCmAJiNNgOxIDGVQA'
}

export default {
  TOKEN,
  BASE_URL,
}
