import { createApp } from 'vue'
import App from './App.vue'
import MyComponent from '@/components/MyComponent'
import { VueSvgIconPlugin } from '@yzfe/vue3-svgicon'
import '@yzfe/svgicon/lib/svgicon.css'

import {
  create,
  NSpace,
  NInput,
  NDropdown,
  NIcon,
  NCollapse,
  NCollapseItem,
  NTabs,
  NTabPane,
  NEmpty,
  NButton,
  NDrawer,
  NDrawerContent,
  NCheckbox,
  NDatePicker,
  NSwitch,
  NInputNumber,
  NCarousel,
  NModal,
  NForm,
  NFormItem,
  NSelect,
  NDataTable,
  NTag,
  NGrid,
  NFormItemGi,
  NUpload,
  NLayout,
  NLayoutSider,
  NLayoutHeader,
  NLayoutContent,
  NMenu,
} from 'naive-ui'
import { normalizeHue } from 'naive-ui/lib/color-picker/src/utils'

const naive = create({
  components: [
    NSpace,
    NInput,
    NDropdown,
    NIcon,
    NCollapse,
    NCollapseItem,
    NTabs,
    NTabPane,
    NEmpty,
    NButton,
    NDrawer,
    NDrawerContent,
    NCheckbox,
    NDatePicker,
    NSwitch,
    NInputNumber,
    NCarousel,
    NModal,
    NForm,
    NFormItem,
    NSelect,
    NDataTable,
    NTag,
    NGrid,
    NFormItemGi,
    NUpload,
    NLayout,
    NLayoutSider,
    NMenu,
    NLayoutHeader,
    NLayoutContent,
  ],
})

createApp(App)
  .use(MyComponent)
  .use(naive)
  .use(VueSvgIconPlugin, {
    tagName: 'svg-icon',
  })
  .mount('#app')
