import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import vueJsx from '@vitejs/plugin-vue-jsx'
import { resolve } from 'path'
import svgicon from 'vite-plugin-svgicon'
import alias from '@rollup/plugin-alias'

export default defineConfig({
  plugins: [
    alias(),
    vue(),
    vueJsx(),
    svgicon({
      include: ['**/images/**/*.svg'],
    }),
  ],
  resolve: {
    alias: {
      '@': resolve(__dirname, './src'),
      '@images': resolve(__dirname, './src/assets/images'),
    },
  },
  server: {
    port: 3001,
    proxy: {
      '/api': {
        target: 'https://www.maicedata.com/collector/data/',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, ''),
      },
    },
  },
  base:
    process.env.NODE_ENV === 'production'
      ? '/statics/huamu_party_building_3d/'
      : './',
})
