import XLSX from 'xlsx'
/**
 * 导出文件为excel
 * @param data 数组
 * @param defaultFileName 默认导出名字（可选）
 */
export default async function useExportXlsx(
  data: any[],
  defaultFileName: string = '导出',
) {
  const head = Object.keys(data[0])
  const content = data.map((e: any) => Object.values(e))
  content.unshift(head)

  const wb = XLSX.utils.book_new()
  const ws = XLSX.utils.aoa_to_sheet(content)
  XLSX.utils.book_append_sheet(wb, ws, 'sheet1')
  XLSX.writeFile(wb, `${defaultFileName}.xlsx`)
}
