import ajax from '@/server/ajax'
import api from '@/server/api'
import common from '@/util/common'
import moment from 'moment'

const {confirm} = common
export default {
  initData({dispatch}) {
    dispatch('getCommunityHealth')
    dispatch('getTheme')
    dispatch('getChecker')
    dispatch('getCommunity')
    dispatch('getRectify')
    dispatch('getPhone')
    dispatch('getSeat')
    dispatch('getRepairNum')
    dispatch('getMaintainer')
    dispatch('setSmartInfo')
    dispatch('setTaskList')
    dispatch('setDistrictCommunity')
    dispatch('setCommunityType')
    dispatch('setSummaryInfo')
  },
  getCommunityHealth({commit}) { // 小区健康度
    ajax.get({url: api.GET_COMMUNITY_HEALTH}).then(res => {
      commit('SET_COMMUNITY_HEALTH', confirm(res, 'data.avg', 0))
    })
  },
  getTheme({commit}) { // 检查主题数
    ajax.post({
      url: api.POST_THEME,
      params: {
        flag: 0,
        someday: moment().format('YYYYMMDD'),
        pageSize: 1,
      }
    }).then(res => {
      commit('SET_THEME', +confirm(res, 'data.totalRows', 0))
    })
  },
  getChecker({commit}) { // 检查人数
    const today = moment().format('YYYY-MM-DD')
    ajax.post({
      url: api.POST_CHECKER,
      params: {
        startDate: today + ' 00:00:00',
        endDate: today + ' 24:00:00',
      }
    }).then(res => {
      commit('SET_CHECKER', +confirm(res, 'data.totalRows', 0))
    })
  },
  getCommunity({commit}) { // 检查小区数
    ajax.post({
      url: api.POST_COMMUNITY,
      params: {
        someday: moment().format('YYYYMMDD'),
        isPublish: 0,
        pageSize: 1,
      }
    }).then(res => {
      commit('SET_COMMUNITY', +confirm(res, 'data.totalRows', 0))
    })
  },
  getRectify({commit}) { // 整改单数
    ajax.post({
      url: api.POST_RECTIFY,
      params: {
        someday: moment().format('YYYYMMDD'),
        isPublish: 1,
        pageSize: 1,
      }
    }).then(res => {
      commit('SET_RECTIFY', +confirm(res, 'data.totalRows', 0))
    })
  },
  getPhone({commit}) { // 当日接通/来点数，及连通率
    ajax.post({url: api.POST_PHONE}).then(res => {
      const {ANSWERS, CALLS, RATE} = confirm(res, 'data.content.0', {ANSWERS: 0, CALLS: 0, RATE: 0})
      commit('SET_PHONE', [+ANSWERS, +CALLS])
      commit('SET_LINK_RATE', +RATE)
    })
  },
  getSeat({commit}) { // 排队/坐席人数
    ajax.post({url: api.POST_SEAT}).then(res => {
      const {CALLQUEUINGS, SEATCOUNT} = confirm(res, 'data.content.0', {CALLQUEUINGS: 0, SEATCOUNT: 0})
      commit('SET_SEAT', [+CALLQUEUINGS, +SEATCOUNT])
    })
  },
  getRepairNum({commit}) { // 保修单数量
    ajax.post({url: api.POST_REPAIR_NUM}).then(res => {
      const {REPAIREORDRERCOUNT} = confirm(res, 'data.content.0', {REPAIREORDRERCOUNT: 0})
      commit('SET_REPAIR_NUM', +REPAIREORDRERCOUNT)
    })
  },
  getMaintainer({commit}) { // 在线维修工数量
    ajax.post({url: api.POST_MAINTAINER}).then(res => {
      commit('SET_MAINTAINER_NUM', +confirm(res, 'data.totalRows', 0))
    })
  },
  setSmartInfo({commit}) { // 智能感知应用场景数据
    ajax.get({url: api.GET_SMART_INFO}).then(res => {
      commit('SET_SMART_INFO', confirm(res, 'data.content', []))
    })
  },
  setTaskList({commit, dispatch}) { // 灾情应用场景下拉选项列表
    ajax.post({
      url: api.POST_TASK_LIST,
      params: {pageSize: 10000},
    }).then(res => {
      const result = confirm(res, 'data.content', [])
      commit('SET_TASK_LIST', result)
      if (result.length > 0) {
        dispatch('setDisasterInfo', result[0].TASKID)
        dispatch('setDisasterCommunity', result[0].TASKID)
      }
    })
  },
  setDisasterInfo({commit}, id) { // 根据场景id查询灾情数据
    ajax.post({
      url: api.POST_DISASTER_INFO,
      params: {
        type: '3',
        pageSize: 10000,
        taskId: id,
      },
    }).then(res => {
      commit('SET_DISASTER_INFO', confirm(res, 'data.content', []))
    })
  },
  setDisasterCommunity({commit}, id) { // 根据场景id查询灾情受灾小区数
    ajax.post({
      url: api.POST_DISASTER_COMMUNITY,
      params: {taskId: id},
    }).then(res => {
      const {SEVERENUM, SLIGHTNUM} = confirm(res, 'data.content', {SEVERENUM: 0, SLIGHTNUM: 0})
      commit('SET_DISASTER_COMMUNITY', [+SEVERENUM, +SLIGHTNUM])
    })
  },
  setDistrictCommunity({commit}) { // 各行政区住宅小区汇总
    ajax.post({url: api.POST_DISTRICT_COMMUNITY}).then(res => {
      commit('SET_DISTRICT_COMMUNITY', confirm(res, 'data.content', []))
    })
  },
  setCommunityType({commit}) { // 住宅小区类型分布
    ajax.post({url: api.POST_COMMUNITY_TYPE}).then(res => {
      commit('SET_COMMUNITY_TYPE', confirm(res, 'data.content', []))
    })
  },
  setSummaryInfo({commit}) { // 小区数、物业企业数等汇总信息
    ajax.post({url: api.POST_SUMMARY_INFO}).then(res => {
      commit('SET_SUMMARY_INFO', confirm(res, 'data.content.0', {}))
    })
  },
}
