import ajax from '@/server/ajax'
import api from '@/server/api'
import common from '@/util/common'
import moment from 'moment'

const {confirm} = common
export default {
  initData({dispatch}) {
    dispatch('getCommunityHealth')
    dispatch('getTheme')
    dispatch('getChecker')
    dispatch('getCommunity')
    dispatch('getRectify')
    dispatch('getPhone')
  },
  getCommunityHealth({commit}) {
    ajax.get({url: api.GET_COMMUNITY_HEALTH}).then(res => {
      commit('SET_COMMUNITY_HEALTH', confirm(res, 'data.avg', 0))
    })
  },
  getTheme({commit}) {
    ajax.post({
      url: api.POST_THEME,
      params: {
        flag: 0,
        someday: moment().format('YYYYMMDD'),
        pageSize: 1,
      }
    }).then(res => {
      commit('SET_THEME', +confirm(res, 'data.totalRows', 0))
    })
  },
  getChecker({commit}) {
    const today = moment().format('YYYY-MM-DD')
    ajax.post({
      url: api.POST_CHECKER,
      params: {
        startDate: today + ' 00:00:00',
        endDate: today + ' 24:00:00',
      }
    }).then(res => {
      commit('SET_CHECKER', +confirm(res, 'data.totalRows', 0))
    })
  },
  getCommunity({commit}) {
    ajax.post({
      url: api.POST_COMMUNITY,
      params: {
        someday: moment().format('YYYYMMDD'),
        isPublish: 0,
        pageSize: 1,
      }
    }).then(res => {
      commit('SET_COMMUNITY', +confirm(res, 'data.totalRows', 0))
    })
  },
  getRectify({commit}) {
    ajax.post({
      url: api.POST_RECTIFY,
      params: {
        someday: moment().format('YYYYMMDD'),
        isPublish: 1,
        pageSize: 1,
      }
    }).then(res => {
      commit('SET_RECTIFY', +confirm(res, 'data.totalRows', 0))
    })
  },
  getPhone({commit}) {
    ajax.post({url: api.POST_PHONE}).then(res => {
      const {ANSWERS, CALLS} = confirm(res, 'data.content.0', {ANSWERS: 0, CALLS: 0})
      commit('SET_PHONE', [ANSWERS, CALLS])
    })
  }
}
