import Vue from 'vue'
import Router from 'vue-router'
import Cookie from '@/util/local-cookie'
import routes from './routes'

Vue.use(Router)

const config = {
  routes,
}
const router = new Router(config)

router.beforeEach((to, from, next) => {
  const token = Cookie.get('token')
  if (!token && to.name !== 'login') {
    next('/login')
  } else {
    next()
  }
})

export default router
