// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import 'babel-polyfill'
import Vue from 'vue'
import App from './App'
import router from './router'
import store from './store'
import ajax from './server/ajax'
import api from './server/api'
import cookie from './util/local-cookie'
import common from './util/common'
import GanttChart from '@/components/GanttChart'
import ActiveForm from '@/components/ActiveForm'
import {LocaleProvider, Tabs, Button, Modal, Form, Row, Col, Input, message, Spin, Dropdown, Icon, Menu, DatePicker, Popconfirm} from 'ant-design-vue'
import moment from 'moment'
import 'moment/locale/zh-cn'
moment.locale('zh-cn')

Vue.config.productionTip = false
Vue.prototype.$message = message
Vue.prototype.$ajax = ajax
Vue.prototype.$api = api
Vue.prototype.$cookie = cookie
Vue.prototype.$com = common

Vue.use(GanttChart)
Vue.use(ActiveForm)
Vue.use(LocaleProvider)
Vue.use(Modal)
Vue.use(Tabs)
Vue.use(Button)
Vue.use(Form)
Vue.use(Row)
Vue.use(Col)
Vue.use(Input)
Vue.use(Spin)
Vue.use(Dropdown)
Vue.use(Icon)
Vue.use(DatePicker)
Vue.use(Menu)
Vue.use(Popconfirm)

/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  store,
  components: { App },
  template: '<App/>'
})
