// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import 'babel-polyfill'
import Vue from 'vue'
import App from './App'
import router from './router'
import GanttChart from '@/components/GanttChart'
import {LocaleProvider, Tabs, Button, message} from 'ant-design-vue'
import moment from 'moment'
import 'moment/locale/zh-cn'
moment.locale('zh-cn')

Vue.config.productionTip = false
Vue.prototype.$message = message

Vue.use(GanttChart)
Vue.use(LocaleProvider)
Vue.use(Tabs)
Vue.use(Button)

/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  components: { App },
  template: '<App/>'
})
