export const config = {
  date_format: '%Y-%m-%d',
  work_time: true,
  columns: [
    {name:'text', label:'任务名', tree:true, align: 'left'},
    {name:'name', label:'人员', align: 'center', max_width: 200},
    {name:'start_date', label:'开始日期', align: 'center', max_width: 100},
    {name:'end_date', label:'结束日期', align: 'center', max_width: 100},
    {name:'duration', label:'周期', align: 'center', max_width: 50},
    {name:'add', label:'', max_width: 50},
  ],
  grid_width: 600,
  row_height: 24,
  date_scale: '%M%d日', // 列日期
  drag_links: false,
}

export const template = {
  task_text: (start, end, task) => { // 柱上加进度百分比
    return Math.round(task.progress * 100) + '%'
  },
  tooltip_text: (start, end, task) => { // 浮框
    return `
      <b>任务名：${task.text}</b><br/>
      <b>姓名：${task.name}</b><br/>
      <b>开始时间：${gantt.templates.tooltip_date_format(task.start_date)}</b><br/>
      <b>结束时间：${gantt.templates.tooltip_date_format(task.end_date)}</b><br/>
      <b>周期：${task.duration}天</b><br/>
      <b>当前进度：${Math.round(100 * task.progress)}%</b><br/>
      ${template.leftside_text(start, end, task)}
    `
  },
  timeline_cell_class: (task, date) => { // 给周末加上classname
    if (!gantt.isWorkTime({task, date})) {
      return 'weekend'
    }
  },
  leftside_text: (start, end, task) => { // 柱左边显示推迟时间
    if (task.planned_start && start.getTime() > task.planned_start.getTime()) {
      const overdue = Math.ceil(Math.abs((start.getTime() - task.planned_start.getTime()) / (24 * 60 * 60 * 1000)))
      return `<b>推迟：${overdue}天</b>`
    }
    return ''
  },
}
