import ajax from '@/server/ajax'
import api from '@/server/api'
import com from '@/util/common'

export default {
  initData({dispatch}) {
    dispatch('getNonLiving')
  },
  async getNonLiving({commit}) {
    const yi = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        '488456305960370176_in': '衣',
        '488456306136530944': '第一工作站',
        pageSize: 1000,
      }
    })
    const shi = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        '488456305960370176_in': '食',
        '488456306136530944': '第一工作站',
        pageSize: 1000,
      }
    })
    const zhu = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        '488456305960370176_in': '住',
        '488456306136530944': '第一工作站',
        pageSize: 1000,
      }
    })
    const xing = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        '488456305960370176_in': '行',
        '488456306136530944': '第一工作站',
        pageSize: 1000,
      }
    })
    const other = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        '488456305960370176_in': '商,学,医,政',
        '488456306136530944': '第一工作站',
        pageSize: 1000,
      },
    })
    const result = [
      ...com.confirm(yi, 'data.content', []).map(item => {
        item.icon = 'yi.png'
        item.size = 20
        item._type = 'yi'
        return item
      }),
      ...com.confirm(shi, 'data.content', []).map(item => {
        item.icon = 'shi.png'
        item.size = 20
        item._type = 'shi'
        return item
      }),
      ...com.confirm(zhu, 'data.content', []).map(item => {
        item.icon = 'zhu.png'
        item.size = 20
        item._type = 'zhu'
        return item
      }),
      ...com.confirm(xing, 'data.content', []).map(item => {
        item.icon = 'xing.png'
        item.size = 20
        item._type = 'xing'
        return item
      }),
      ...com.confirm(other, 'data.content', []).map(item => {
        if (item['488456305960370176'] === '医') {
          item.icon = 'yi2.png'
        }
        if (item['488456305960370176'] === '学') {
          item.icon = 'xue.png'
        }
        if (item['488456305960370176'] === '商') {
          item.icon = 'shang.png'
        }
        if (item['488456305960370176'] === '政') {
          item.icon = 'zheng.png'
        }
        item.size = 20
        item._type = 'other'
        return item
      }),
    ]
    result.forEach(item => {
      if (item['479477007408168960'].indexOf('重庆北路小学') >= 0) {
        item.photo = 'school1.jpg'
      }
      if (item['479477007408168960'].indexOf('储能中学') >= 0) {
        item.photo = 'school2.jpg'
      }
      if (item['479477007408168960'].indexOf('威海路幼儿园') >= 0) {
        item.photo = 'school3.jpeg'
      }
    })
    commit('SET_NON_LIVING', result)
  },
}
