import ajax from '@/server/ajax'
import api from '@/server/api'
import com from '@/util/common'

export default {
  initData({dispatch}) {
    dispatch('getNonLiving')
  },
  async getNonLiving({commit}) {
    const yi = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        '488439151152132096': '衣',
        '488439152448172032': '第一工作站',
        pageSize: 1000,
      }
    })
    const shi = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        '488439151152132096': '食',
        '488439152448172032': '第一工作站',
        pageSize: 1000,
      }
    })
    const zhu = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        '488439151152132096': '住',
        '488439152448172032': '第一工作站',
        pageSize: 1000,
      }
    })
    const xing = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        '488439151152132096': '行',
        '488439152448172032': '第一工作站',
        pageSize: 1000,
      }
    })
    const result = [
      ...com.confirm(yi, 'data.content', []).map(item => {
        item.icon = 'tip3.png'
        return item
      }),
      ...com.confirm(shi, 'data.content', []).map(item => {
        item.icon = 'tip4.png'
        return item
      }),
      ...com.confirm(zhu, 'data.content', []).map(item => {
        item.icon = 'tip5.png'
        return item
      }),
      ...com.confirm(xing, 'data.content', []).map(item => {
        item.icon = 'tip6.png'
        return item
      }),
    ]
    commit('SET_NON_LIVING', result)
  },
}
