import ajax from '@/server/ajax'
import api from '@/server/api'
import com from '@/util/common'

export default {
  initData({dispatch}) {
    dispatch('getNonLiving')
  },
  async getNonLiving({commit}) {
    const main = await ajax.get({
      url: api.GET_NON_LIVING,
      params: {
        // '488456305960370176_orl': '衣,食,住,行,商,学,医,政,垃圾,历史保护,地标,药,公厕,居委,工作站,助浴,倒粪,为老服务,地铁,消防,便利,菜,餐车,饭店',
        '488456306136530944': '第一工作站',
        pageSize: 1000,
      }
    })
    const result = [
      ...com.confirm(main, 'data.content', []).map(item => {
        const name = item.livehoodType || ''
        if (name.indexOf('医') >= 0) {
          item.icon = 'yi2.png'
          item._type = 'other'
        }
        if (name.indexOf('学') >= 0) {
          item.icon = 'xue.png'
          item._type = 'other'
        }
        if (name.indexOf('商') >= 0) {
          item.icon = 'shang.png'
          item._type = 'other'
        }
        if (name.indexOf('政') >= 0) {
          item.icon = 'zheng.png'
          item._type = 'other'
        }
        if (name.indexOf('衣') >= 0) {
          item.icon = 'yi.png'
          item._type = 'yi'
        }
        if (name.indexOf('食') >= 0) {
          item.icon = 'shi.png'
          item._type = 'shi'
        }
        if (name.indexOf('住') >= 0) {
          item.icon = 'zhu.png'
          item._type = 'zhu'
        }
        if (name.indexOf('行') >= 0) {
          item.icon = 'xing.png'
          item._type = 'xing'
        }
        item.size = 20
        return item
      }),
    ]
    result.forEach(item => {
      if (item.unitAddr === '大沽路123号') {
        item.icon = 'star-sm.png'
        item.photo = 'photo5.jpg'
      }
      if (item.unitAddr === '人民大道200号') {
        item.icon = 'star.png'
        item.photo = 'photo3.jpg'
      }
      if (item.unitAddr === '延安东路523号') {
        item.photo = 'photo13.jpg'
      }
      if (item.unitAddr === '南京西路170号') {
        item.photo = 'photo9.jpg'
      }
      if (item.unitAddr === '南京西路150号') {
        item.photo = 'photo11.jpg'
      }
      if (item.unitAddr === '南京西路104号') {
        item.photo = 'photo10.jpg'
      }
      if (item.unitAddr === '南京西路216号') {
        item.photo = 'photo8.jpg'
      }
      if (item.unitAddr === '南京西路325号') {
        item.photo = 'photo14.jpg'
      }
      if (item.unitAddr === '武胜路429号') {
        item.photo = 'photo7.jpg'
      }
      if (item.unitAddr === '凤阳路450号') {
        item.photo = 'photo12.jpg'
      }
      if (item.unitAddr === '人民大道201号') {
        item.photo = 'photo1.jpg'
      }
      if (item.unitAddr === '南京西路325号') {
        item.photo = 'photo2.jpg'
      }
      if (item.unitAddr === '淮海中路98号金钟广场') {
        item.photo = 'photo4.jpg'
      }
      if (item.unitAddr === '延安东路普安路') {
        item.photo = 'toilet1.jpeg'
      }
      if (item.unitAddr === '九江路951号') {
        item.photo = 'toilet3.jpeg'
      }
      if (item.unitAddr === '重庆北路228号') {
        item.photo = 'school4.jpeg'
      }
      if (item.unitAddr === '重庆北路173号') {
        item.photo = 'school5.jpeg'
      }
      if (item['479477007408168960'].indexOf('重庆北路小学') >= 0) {
        item.photo = 'school1.jpg'
      }
      if (item['479477007408168960'].indexOf('储能中学') >= 0) {
        item.photo = 'school2.jpg'
      }
      if (item['479477007408168960'].indexOf('威海路幼儿园') >= 0) {
        item.photo = 'school3.jpeg'
      }
    })
    commit('SET_NON_LIVING', result)
  },
}
