import { ajax, api } from '@/ajax'
import { Dispatch, Commit } from 'vuex'
import inImg from '@/assets/images/in.png'
import china from '@/assets/images/china.png'
import out from '@/assets/images/out.png'

export default {
  initData({ dispatch }: { dispatch: Dispatch }): void {
    dispatch('getPropertySummary')
    dispatch('getCaseList')
    // dispatch('GET_PUBLICSAFE_ECONOMIC')
  },
  // 物业三架马车数据 （缺交叉任职数）
  async getPropertySummary({ commit }: { commit: Commit }): Promise<void> {
    const {
      GET_COMMITTEE: url1,
      GET_INDUSTRY_AUTHORITY: url2,
      GET_COMPANY: url3,
    } = api
    const [num1, num2, num3] = await Promise.all(
      [url1, url2, url3].map(async (url) => {
        return (await ajax.get({ url, params: { pageSize: 1 } })).data.totalRows
      })
    )
    commit('SET_PROPERTY_SUMMARY', { num1: +num1, num2: +num2, num3: +num3 })
  },

  // 案件汇总列表
  async getCaseList({ commit }: { commit: Commit }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_CASE, params: { pageSize: 100 } })
    ).data
    commit('SET_CASE_LIST', content)
  },

  // // 工作站列表
  // async getStation({ commit }: { commit: Commit }): Promise<void> {
  //   const { content } = (await ajax.get({ url: api.GET_STATION })).data
  //   commit('SET_STATION_LIST', content)
  // },

  // 公共服务 - 门岗值守 - 社会物业和直管公房数据
  async GET_PUBLICSAFE_NEWFIND({ commit }: { commit: Commit }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_NEWFIND })
    ).data
    const obj = {
      done: 0,
      doing: 0,
      find: 0,
      newFind: content.newDiscovery,
    }
    function format(params: any) {
      params.forEach((item: any) => {
        obj.find += item.num
        switch (item.status) {
          case '已结案':
            obj.done = item.num
            break
          case '待处置':
            obj.find = item.num
            break
          default:
            break
        }
      })
    }
    format(content.caseNum)

    commit('SET_PUBLICSAFE_NEWFIND', obj)
  },
  // 公共服务 - 门岗值守 - 社会物业和直管公房数据
  async GET_PUBLICSAFE_RIGHT_GATE({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_RIGHT_GATE })
    ).data
    const shehuiwuye: any[] = []
    const publicHouse: any[] = []
    function formatData(arr: any[], obj: { [x: string]: any }) {
      for (const k in obj) {
        switch (k) {
          case 'isWatch':
            arr.push({
              index: 3,
              name: '值守处',
              value: obj[k] || 0,
            })
            break
          case 'isClosed':
            arr.push({
              index: 1,
              name: '已封闭',
              value: obj[k] || 0,
            })
            break
          case 'addrNum':
            arr.push({
              index: 0,
              name: '出入口',
              value: obj[k] || 0,
            })
            break
          case 'isSentry':
            arr.push({
              index: 2,
              name: '有门岗处',
              value: obj[k] || 0,
            })
            break

          default:
            break
        }
      }
      arr.sort((a, b) => {
        return a.index - b.index
      })
    }
    formatData(shehuiwuye, content.property)
    formatData(publicHouse, content.publicHouse)
    commit('SET_PUBLICSAFE_GATESENTRY_SHEHUIWUYE', shehuiwuye)
    commit('SET_PUBLICSAFE_GATESENTRY_ZHIGUANGONGFANG', publicHouse)
  },
  // 公共服务 - 门岗值守 - 平安地图
  async GET_PUBLICSAFE_RIGHT_SAFEMAP({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_PUBLICSAFE_RIGHT_SAFEMAP,
        params: { pageSize: 1000 },
      })
    ).data
    commit('SET_PUBLICSAFE_SAFEMAP', content)
  },
  // 公共服务 - 实有人口
  async GET_PUBLICSAFE_TRUE_PEOPLE({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_TRUE_PEOPLE })
    ).data
    commit('SET_PUBLICSAFE_TRUE_PEOPLE', content)
  },
  // 公共服务 - 实有房屋
  async GET_PUBLICSAFE_HOUSE({ commit }: { commit: Commit }): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_PUBLICSAFE_HOUSE })).data
    commit('SET_PUBLICSAFE_HOUSE', content)
    const obj = {
      spf: 0,
      other: 0,
      zggf: 0,
    }
    content.stKind.forEach((item: { stKindName: string; totHous: number }) => {
      switch (item.stKindName) {
        case '商品房':
          obj.spf = item.totHous
          break
        case '直管公房':
          obj.zggf = item.totHous
          break
        default:
          obj.other += item.totHous
          break
      }
    })
    commit('SET_PUBLICSAFE_HOUSE_STKIND', content.stKind)
    commit('SET_PUBLICSAFE_HOUSE_STKIND', obj)
  },
  // 公共服务 - 非居房屋
  async GET_PUBLICSAFE_NONRESIDENT({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_NONRESIDENT })
    ).data
    commit('SET_PUBLICSAFE_NONRESIDENT', content)
  },
  // 公共服务 - 实有单位
  async GET_PUBLICSAFE_TRUE_COMPANY({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_TRUE_COMPANY })
    ).data
    commit('SET_PUBLICSAFE_TRUE_COMPANY', content)
  },
  // 公共服务 - 应急物资储备
  async GET_PUBLICSAFE_SOS_MATERIAL({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_SOS_MATERIAL })
    ).data
    // console.log(content)
    commit('SET_PUBLICSAFE_SOS_MATERIAL', content)
  },
  // 公共服务 - 房屋外立面
  async GET_PUBLICSAFE_OUTHOUSEWALL({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_OUTHOUSEWALL })
    ).data
    // console.log(content, '房屋外立面')
    commit('SET_PUBLICSAFE_OUTHOUSEWALL', content)
  },
  // 公共服务 - 重点关注楼宇
  async GET_PUBLICSAFE_BUILDINGS({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_PUBLICSAFE_BUILDINGS,
        params: { pageSize: 1000 },
      })
    ).data
    commit('SET_PUBLICSAFE_BUILDINGS', content)
  },
  // 公共服务 - 房屋外立面饼图
  async GET_PUBLICSAFE_PIEDATA({ commit }: { commit: Commit }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_PIEDATA })
    ).data
    console.log(content, 'pie')
    commit('SET_PUBLICSAFE_PIEDATA', content)
  },
  // 左侧公共 - 指挥体系
  async GET_PUBLICSAFE_COMMANDSYSTEM({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_COMMANDSYSTEM })
    ).data
    // console.log(content)
    commit('SET_PUBLICSAFE_COMMANDSYSTEM', content)
  },
  // 左侧公共 - 网格工作站
  async GET_PUBLICSAFE_STREETPOWER({
    commit,
  }: {
    commit: Commit
  }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_STREETPOWER })
    ).data
    // console.log(content, '网格工作站)')
    commit('SET_PUBLICSAFE_STREETPOWER', content.workStation || [])
  },
  // 左侧公共 - 党建
  async GET_PUBLICSAFE_PARTY({ commit }: { commit: Commit }): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_PUBLICSAFE_PARTY })).data
    // console.log(content, '党建')
    commit('SET_PUBLICSAFE_PARTY', content)
  },
  // 左侧公共 - 经济
  async GET_PUBLICSAFE_ECONOMIC({ commit }: { commit: Commit }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_ECONOMIC })
    ).data
    // console.log(content, '经济')
    commit('SET_PUBLICSAFE_ECONOMIC', content)
  },

  /** 小区屏 */
  initCommunityData({ dispatch }: { dispatch: Dispatch }, id: string): void {
    dispatch('getCommunityInfo', id)
    dispatch('getIssueList', id)
    dispatch('getCombineList', id)
  },
  async getCommunityInfo(
    { commit }: { commit: Commit },
    id: string
  ): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_COMMUNITY_INFO,
      })
    ).data
    commit(
      'SET_COMMUNITY_INFO',
      content.find((item: any) => item.id === id)
    )
  },
  async getIssueList(
    { commit }: { commit: Commit },
    id: string
  ): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_ISSUE_LIST,
        params: { bigscreenCommunityId: id },
      })
    ).data
    commit('SET_ISSUE_DATA', content)
  },
  async getCombineList(
    { commit }: { commit: Commit },
    id: string
  ): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_COMBINE_LIST,
        params: { bigscreenCommunityId: id },
      })
    ).data
    commit('SET_COMBINE_DATA', content)
  },
  /** 工作站 */
  initStationData({ dispatch }: { dispatch: Dispatch }, id: string): void {
    if (!id) return
    dispatch('getStationById', id)
    dispatch('getDutySum', id)
  },
  async getStationById(
    { commit }: { commit: Commit },
    id: string
  ): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_STATION, params: { id } })
    ).data
    commit('SET_STATION', content && content[0])
  },
  async getDutySum(
    { commit }: { commit: Commit },
    gridId: string
  ): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_DUTY_SUM, params: { gridId } })
    ).data
    commit('SET_DUTY_SUM', content)
  },
  async getDutyList(
    { commit }: { commit: Commit },
    params: { [key: string]: string }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_LIST,
        params,
      })
    ).data
    commit('SET_DUTY_LIST', content)
  },
  async getDutyRank(
    { commit }: { commit: Commit },
    params: { [key: string]: string }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_RANK,
        params,
      })
    ).data
    commit('SET_DUTY_RANK', content)
  },
  async getDutyEvents(
    { commit }: { commit: Commit },
    params: { [key: string]: string }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_EVENTS,
        params,
      })
    ).data
    commit('SET_DUTY_EVENTS', content)
  },
  async getDutyPlaces(
    { commit }: { commit: Commit },
    params: { [key: string]: string }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_PLACES,
        params,
      })
    ).data
    commit('SET_DUTY_PLACES', content)
  },
  async getDutyRanking(
    { commit }: { commit: Commit },
    params: { [key: string]: string }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_RANKING,
        params,
      })
    ).data
    commit('SET_DUTY_RANKING', content)
  },
}
