let BASE_URL = ''
let SOURCE_URL = ''
switch (process.env.NODE_ENV) {
  case 'production':
    // 政务网生产环境
    BASE_URL = 'http://172.82.32.1/nd-api'
    SOURCE_URL = 'http://172.82.32.1/nd-file/'

    // // 政务网生产环境，设置了代理api
    // BASE_URL = '/nd-api'
    // SOURCE_URL = 'http://10.81.71.243:23456/nd-file/'
    break
  case 'test':
    // 普通打包（测试用）
    BASE_URL = 'http://nandong-dev.omniview.pro/nd-api'
    SOURCE_URL = 'http://zhongbang.omniview.pro/'
    break
  default:
    // 开发环境
    BASE_URL = '/api'
    SOURCE_URL = 'http://zhongbang.omniview.pro/'
}

export default {
  BASE_URL,
  SOURCE_URL,
  TEST: '/service-basicdatasync-ddd/public/communities',
  GET_LIST: '/service-special-nandong/public/classifyAddrs', // 根据地址搜索
  GET_ROOM: '/service-special-nandong/public/households', // 获取分户
  GET_PERSON: '/service-special-nandong/public/personnels', // 实有人口
  GET_COMMUNITY: '/service-basicdatasync-ddd/public/communities',
  GET_BUILDINGS: '/service-basicdatasync-ddd/public/buildings', // 门牌户室
  GET_MANAGE: '/service-basicdatasync-ddd/public/css', // 小区管理处
  GET_BUILDING: '/service-basicdatasync-ddd/public/building', // 门牌幢列表
  GET_DEVICE: '/service-basicdatasync-ddd/public/facilitiesEquipment', // 设施设备列表
  GET_INDUSTRY_AUTHORITY: '/service-basicdatasync-ddd/public/indCous', // 业委会列表
  GET_HOC_MEMBER: '/service-basicdatasync-ddd/public/indcou/members', // 业委会成员
  GET_COMMITTEE: '/service-basicdatasync-ddd/public/residentsCommittees', // 居委会列表
  GET_COMPANY: '/service-basicdatasync-ddd/public/propCompanies', // 物业列表
  GET_CASE: '/service-special-nandong/public/compairs', // 案件汇总列表
  GET_CASE_DETAIL: '/service-special-nandong/public/compair', // 案件详情

  GET_FOR_OLD: '/service-special-nandong/public/forOldFacilitiess', // 为老
  GET_MARKETS: '/service-special-nandong/public/vegetableMarkets', // 菜场、药店、便利店
  GET_DUNGS: '/service-special-nandong/public/urDungs', // 倒粪口
  GET_BINS: '/service-special-nandong/public/internalDustbins', // 垃圾箱

  GET_PUBLICSAFE_RIGHT_GATE:
    '/service-special-nandong/public/ironGate/statistical', // 公共安全-右侧-门岗分布
  GET_PUBLICSAFE_RIGHT_SAFEMAP: '/service-special-nandong/public/peaceMaps', // 公共安全-右侧-平安地图
  GET_PUBLICSAFE_HOUSE: '/service-basicdatasync-ddd/public/resource/count', // 公共安全-右侧-居住房屋
  GET_PUBLICSAFE_NONRESIDENT:
    '/service-basicdatasync-ddd/public/nonResident/statistical', // 公共安全-右侧-非居房屋
  GET_PUBLICSAFE_TRUE_COMPANY:
    '/service-special-nandong/public/company/statistical', // 公共安全-右侧-实有单位
  GET_PUBLICSAFE_SOS_MATERIAL:
    '/service-special-nandong/public/emergencySupplies/1', // 公共安全-右侧-应急物资储备
  GET_PUBLICSAFE_OUTHOUSEWALL:
    '/service-special-nandong/public/inspection/statistical', // 公共安全-右侧-房屋外立面
  GET_PUBLICSAFE_BUILDINGS: '/service-special-nandong/public/inspections', // 公共安全-右侧-重点关注楼宇
  GET_PUBLICSAFE_PIEDATA: '/service-special-nandong/public/inspection/getPie', // 公共安全-右侧-房屋外立面饼图
  GET_PUBLICSAFE_NEWFIND: '/service-special-nandong/public/noAlert', // 公共安全-右侧-最新发现

  // 左侧公共
  GET_PUBLICSAFE_MASTER: '/service-special-nandong/public/streetRegister/1', // 指挥长
  GET_PUBLICSAFE_COMMANDSYSTEM:
    '/service-special-nandong/public/managementOffices', // 指挥体系
  GET_PUBLICSAFE_STREETPOWER: '/service-special-nandong/public/workstations', // 网格工作站(原名街道力量)
  GET_GRIDPOWER: '/service-special-nandong/public/workstationDepartments', // 网格力量
  GET_PUBLICSAFE_PARTY: '/service-special-nandong/public/partyConstruction/1', // 党建
  GET_PUBLICSAFE_ECONOMIC: '/service-special-nandong/public/economic/1', // 经济

  /** 小区屏 */
  GET_COMMUNITY_IDS: '/service-special-nandong/public/getSectIdList', // 获取小区id列表
  GET_COMMUNITY_INFO:
    '/service-special-nandong/public/bigscreenCommunity/statistical', // 小区档案
  GET_COMMUNITY_FACILITY: '/service-special-nandong/public/communityRelations', // 小区设施
  GET_ISSUE_LIST: '/service-special-nandong/public/management/factors', // 管理要素列表
  GET_SCORE_ISSUE: '/service-special-nandong/public/score/elements', // 评分要素
  GET_COMBINE_LIST: '/service-special-nandong/public/league/linkage', // 联勤联动列表

  /** 报警发短信 */
  POST_ALARM: '/service-alarm-nandong/public/alarm',

  /** 工作站 */
  GET_STATION: '/service-special-nandong/public/workstations', // 工作站信息
  GET_DUTY_SUM: '/service-special-nandong/public/workStation/dutyNum', // 勤务统计数
  GET_DUTY_LIST: '/service-special-nandong/public/workStation/dutyList', // 勤务列表
  GET_DUTY_RANK: '/service-special-nandong/public/compair/getRanking', // 勤务分析 - 事件类型
  GET_DUTY_EVENTS: '/service-special-nandong/public/compair/getRanking/cmt', // 勤务分析 - 居委事件数量
  GET_DUTY_PLACES: '/service-special-nandong/public/compair/getRanking/addr', // 勤务分析 - 多发地点
  GET_DUTY_RANKING: '/service-special-nandong/public/compair/getRanking/all', // 勤务分析 - 排行
  GET_OLD_SERVICE: '/service-special-nandong/public/forOld/statistics', // 便民 - 为老
  GET_LIFE_CONVENIENT: '/service-special-nandong/public/convenient/statistics', // 便民 - 生活便利

  /** 公共管理 */
  GET_YOUSUBIDA_RANK: '/service-special-nandong/public/compair/willReach', // 有诉必答-占比
  GET_YOUSUBIDA_CLASSIFICATION_RANK:
    '/service-special-nandong/public/compair/willReach/ranking', // 有诉必答-分类排行
  GET_URGENTCASE: '/service-special-nandong/public/compairs', //  有诉必答-紧急案件
  GET_TODAYCASE: '/service-special-nandong/public/compair/willTouch', //  有求必应-今日案件数
  GET_STAGECASE: '/service-special-nandong/public/compair/willTouch/status', // 有求必应-各阶段案件数
  GET_WORKSTATION:
    '/service-special-nandong/public/compair/willTouch/workStation', // 有求必应-工作站分类
  GET_TRACKEVENT: '/service-special-nandong/public/compairs', // 有求必应-事件跟踪
  GET_CASE_CLASSIFICATION_RANK:
    '/service-special-nandong/public/compair/analysis', // 案件分析-分类排行
  GET_MOREHAPPEN_ADDR: '/service-special-nandong/public/compair/analysis/addr', // 案件分析-多发地点
  GET_RESPONSIVITY: '/service-special-nandong/public/compair/responsivity', // 响应度
  GET_ENTRY: '/service-special-nandong/public/inputUrl', // 业务入口

  /** 公共服务 */
  GET_ECOLOGY_LIST: '/service-special-nandong/public/nonResident/ecological', // 生态-衣食住行
  // GET_ECOLOGY_POINTS: '/service-basicdatasync-ddd/public/nonResidents', // 获取衣食住行撒点
  GET_ECOLOGY_POINTS: '/service-special-nandong/public/nonResidentLabels', // 获取衣食住行撒点
  GET_ECOLOGY_CONVENIENT:
    '/service-special-nandong/public/convenient/ecological', // 生态-便民设施
  GET_ECOLOGY_PHOTO: '/service-special-nandong/public/buildingPhotos', // 生态 - 商业综合体、文保、历保照片
  GET_ELEV_COUNT: '/service-special-nandong/public/elevatorAdd/workstation', // 美丽家园-电梯加装统计数字
  GET_ELEV_LIST: '/service-special-nandong/public/elevatorAdds', // 美丽家园 - 根据名称查询列表
  GET_TOILET: '/service-special-nandong/public/toiletRenovations', // 马桶改造

  GET_BEAUTY_STREET: '/service-special-nandong/public/beautifulStreets', // 美丽街区
  GET_BEAUTY_STREET_EXECUTE:
    '/service-special-nandong/public/beautifulStreet/threeYearStatistics', // 美丽街区项目实施情况
  GET_BEAUTY_STREET_STATISTICS:
    '/service-special-nandong/public/beautifulStreet/projectTypeStatisticsWithYear', // 美丽街区项目分类统计
  GET_BEAUTY_HOME: '/service-special-nandong/public/beautifulHomes', // 美丽家园
  GET_BEAUTY_HOME_EXECUTE:
    '/service-special-nandong/public/beautifulHome/threeYearStatistics', // 美丽家园项目实施情况
  GET_EVENTS: '/service-special-nandong/public/compairs', // 事件
  GET_WISDOM_OLD: '/service-special-nandong/public/wisdom/0', // 智慧养老
  GET_FOCUS_WORK: '/service-special-nandong/public/focusWorks', // 重点工作

  /** 新版小区屏 */
  GET_MONITOR: '/service-special-nandong/public/equipments/0', // 获取监控设备
  GET_VIDEO_URL: '/service-special-nandong/public/video/{id}', // 根据设备id获取视频流
  GET_DISCOVER_SUM: '/service-special-nandong/public/discover/method/count', // 发现方式统计
  GET_DISCOVER_STATISTICS:
    '/service-special-nandong/public/discover/category/count', // 发现数据
  GET_DISCOVER_COUNT: '/service-special-nandong/public/discover/count', // 今日及历史发现数
  GET_DISCOVER_LIST: '/service-special-nandong/public/discoverys', // 快处闭环

  /** 来福士 */
  GET_RAFFLES: '/service-special-nandong/public/lfss', // 来福士列表
  GET_RAFFLES_RENT: '/service-special-nandong/public/lfsRents', // 来福士租金
}
