import axios, { AxiosRequestConfig, AxiosPromise } from 'axios'
import qs from 'qs'
import api from './api'
import store from '@/store'

const Axios = axios.create({
  baseURL: api.BASE_URL,
  timeout: 15000,
})
Axios.interceptors.request.use(
  (config) => {
    // 添加token
    config.headers.Authorization =
      'bearer eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX2lkIjoiMSIsImVuYWJsZSI6dHJ1ZSwic2NvcGUiOlsicmVhZCIsIndyaXRlIiwidHJ1c3QiXSwiZXhwIjoxNjE4NTQ4MjY1LCJqdGkiOiJhMzM3YTJlMy0xOThiLTQ3ZGUtYjQ0Zi03MWE5OWU4YTUzMGUiLCJjbGllbnRfaWQiOiJzc28iLCJ0aW1lc3RhbXAiOjE2MTg1NDEwNjU5NzB9.Yt7LzQ_izQxqFdpaaElHX-ZJaLcky3j3y68jPQOo2Rq8pQPO9cYXSAjpKfNvOWTfZzL9fs110JUbY_u0qmtWB_lzP5-VRIIVFDuSArh6YJ5FARN3g_HT82aPvfDq6JkV3epw3d8PIA7GJlg0BE2NqR6AxpEyOKCGflGHG35E6KubYpku7xAGlPHgkOB2jjEl5e-Lxgmcqis5UVzXHtfAbm8lra68A_jNkn3y2SiZme4i6kISeGPqmxcwRdnANci_QkRzCTvY2uE4Qy-IpQ1XxgMBAyZVCjr4T0FlOhxOVhgweytu9-_QKBYmpNAg1K3AksrCIpfaHXckwcG6vAaBow'
    return config
  },
  (error) => {
    return Promise.reject(error)
  }
)

Axios.interceptors.response.use(
  (response) => {
    // TODO 返回的数据status判断错误操作等……
    store.commit('SET_LOADING', false)
    return response.data
  },
  (error) => {
    store.commit('SET_LOADING', false)
    return Promise.reject(error)
  }
)

interface ParamsProp {
  [propName: string]: unknown
}

interface RequestOptions {
  method?:
    | 'GET'
    | 'get'
    | 'delete'
    | 'DELETE'
    | 'head'
    | 'HEAD'
    | 'options'
    | 'OPTIONS'
    | 'post'
    | 'POST'
    | 'put'
    | 'PUT'
    | 'patch'
    | 'PATCH'
    | 'purge'
    | 'PURGE'
    | 'link'
    | 'LINK'
    | 'unlink'
    | 'UNLINK'
    | undefined
  url: string
  params?: ParamsProp
  contentType?:
    | 'application/json;charset=UTF-8'
    | 'application/x-www-form-urlencoded;charset=UTF-8'
  showLoading?: boolean
}

/**
 * 请求
 * @param {String} method [请求方法]
 * @param {String} url [请求地址]
 * @param {Object} params [请求参数]
 * @param {String} contentType [请求头，默认为'application/json;charset=UTF-8']
 * @param {Boolean} showLoading [是否显示请求时的loading图，默认为true]
 */
const ajax = ({
  method = 'GET',
  url,
  params = {},
  contentType = 'application/json;charset=UTF-8',
  showLoading = true,
}: RequestOptions) => {
  if (!url || typeof url != 'string') {
    throw new Error('接口URL不正确')
  }
  let config: AxiosRequestConfig = {
    method,
    url,
    headers: {
      'X-Requested-With': 'XMLHttpRequest',
      'Content-Type': contentType,
      'Access-Control-Allow-Origin': '*',
      'Access-Control-Allow-Headers':
        'Authorization,Origin, X-Requested-With, Content-Type, Accept',
      'Access-Control-Allow-Methods': '*',
    },
  }
  if (method === 'GET') {
    config = Object.assign(config, { params })
  } else {
    if (contentType.toLowerCase().indexOf('x-www-form-urlencoded') >= 0) {
      config = Object.assign(config, { data: qs.stringify(params) })
    } else {
      config = Object.assign(config, { data: params })
    }
  }
  if (showLoading) {
    store.commit('SET_LOADING', true)
  }
  return Axios(config)
}

export default {
  get(args: RequestOptions): AxiosPromise<any> {
    return ajax({ method: 'GET', ...args })
  },
  post(args: RequestOptions): AxiosPromise<any> {
    // args.contentType = 'application/x-www-form-urlencoded;charset=UTF-8'
    return ajax({ method: 'POST', ...args })
  },
  put(args: RequestOptions): AxiosPromise<any> {
    return ajax({ method: 'PUT', ...args })
  },
  delete(args: RequestOptions): AxiosPromise<any> {
    return ajax({ method: 'DELETE', ...args })
  },
}
