import { createStore } from 'vuex'
import state from './state'
import mutations from './mutations'
import actions from './actions'

export type ThemeType = 'manage' | 'service' | 'safety'
export interface ViewType {
  name: string
  type: 'street' | 'work1' | 'work2' | 'work3'
}
export interface GlobalStateProps {
  showLoading: boolean
  curView: ViewType
  readonly viewOptions: ViewType[]
  curTheme: ThemeType
  propertySummary: { [key: string]: number }
  caseList: unknown[]
  stationList: unknown[]
}
export default createStore<GlobalStateProps>({
  state,
  mutations,
  actions,
})
