import { ajax, api } from '@/ajax'
import { Dispatch, Commit } from 'vuex'

export default {
  initData({ dispatch }: { dispatch: Dispatch }): void {
    dispatch('getPropertySummary')
  },
  // 物业三架马车数据
  async getPropertySummary({ commit }: { commit: Commit }): Promise<void> {
    const {
      GET_COMMITTEE: url1,
      GET_INDUSTRY_AUTHORITY: url2,
      GET_COMPANY: url3,
    } = api
    const [num1, num2, num3] = await Promise.all(
      [url1, url2, url3].map(async (url) => {
        return (await ajax.get({ url, params: { pageSize: 1 } })).data.totalRows
      })
    )
    commit('SET_PROPERTY_SUMMARY', { num1: +num1, num2: +num2, num3: +num3 })
  },
}
