import { createStore } from 'vuex'
import state from './state'
import mutations from './mutations'
import actions from './actions'

export type ThemeType = 'manage' | 'service' | 'safety'
export interface ViewType {
  name: string
  type: 'street' | 'work1' | 'work2' | 'work3'
}
export interface GlobalStateProps {
  showLoading: boolean
  curView: ViewType
  readonly viewOptions: ViewType[]
  curTheme: ThemeType
  propertySummary: { [key: string]: number }
  caseList: unknown[]
  stationList: unknown[]
  pubulicSafeGateSenteryShehuiwuye: { [key: string]: number }
  pubulicSafeGateSenteryZhiguangongfang: { [key: string]: number }
  pubulicSafeMap: unknown[]
  pubulicSafeTruePeople: { [key: string]: number }
  pubulicSafeHouse: { [key: string]: any }
  pubulicSafeNonResident: { [key: string]: any }
  pubulicSafeHouseStKind: { [key: string]: number }
  pubulicSafeTrueCompany: { [key: string]: number }
  pubulicSafeSOSMaterail: { [key: string]: number }
  pubulicSafeOutHouseWall2019: { [key: string]: number }
  pubulicSafeOutHouseWall2020: { [key: string]: number }
  pubulicSafeBuildings: unknown[]
  pubulicSafePieData: unknown[]
  pubulicSafeNewFindNum: { [key: string]: number }
  pubulicSafeOutHouseWall: any[]
}
export default createStore<GlobalStateProps>({
  state,
  mutations,
  actions,
})
