import { ajax, api } from '@/ajax'
import { Dispatch, Commit } from './index'
import dayjs from 'dayjs'
import yi from '@/assets/images/yi.png'
import shi from '@/assets/images/shi.png'
import zhu from '@/assets/images/zhu.png'
import xing from '@/assets/images/xing.png'
import other from '@/assets/images/other.png'
import water from '@/assets/images/water.png'
import land from '@/assets/images/land.png'
import history from '@/assets/images/history.png'
import old from '@/assets/images/old.png'
import smStar from '@/assets/images/star-sm.png'
import star from '@/assets/images/star.png'

interface Method {
  commit: Commit
  dispatch: Dispatch
}

const today = dayjs().format('YYYY-MM-DD')

export default {
  initData({ dispatch }: Method): void {
    /** 初始化数据 */
    dispatch('getPropertySummary')
    dispatch('GET_PUBLICSAFE_COMMANDSYSTEM')
    dispatch('GET_PUBLICSAFE_STREETPOWER')
    dispatch('GET_PUBLICSAFE_PARTY')
    dispatch('GET_PUBLICSAFE_ECONOMIC')
    dispatch('GET_PUBLICSAFE_TRUE_COMPANY')
    dispatch('GET_YOUSUBIDA_RANK')
    dispatch('GET_YOUSUBIDA_CLASSIFICATION_RANK')
    dispatch('GET_URGENTCASE', {
      bxmaintainType: '1',
      // status_in: '待派遣,已派单',
      acceptTime_gte: today,
      pageSize: 100,
    })
    dispatch('GET_TODAYCASE')
    dispatch('GET_STAGECASE')
    dispatch('GET_WORKSTATION')
    dispatch('GET_TRACKEVENT', {
      // status_in: '待处置,已签收',
      acceptTime_gte: today,
      pageSize: 100,
    })
    dispatch('GET_CASE_CLASSIFICATION_RANK', {
      managementType: '综合',
    })
    dispatch('GET_MOREHAPPEN_ADDR', {
      managementType: '综合',
    })
    dispatch('GET_COMMUNITY_PATHS')
    dispatch('GET_RESPONSIVITY')
    dispatch('GET_ENTRY')
    dispatch('GET_PUBLICSAFE_SOS_MATERIAL')
    dispatch('GET_PUBLICSAFE_OUTHOUSEWALL')
    dispatch('GET_PUBLICSAFE_BUILDINGS')
    dispatch('GET_PUBLICSAFE_PIEDATA')
    dispatch('GET_PUBLICSAFE_HOUSE')
    dispatch('GET_PUBLICSAFE_NONRESIDENT')
    dispatch('GET_PUBLICSAFE_RIGHT_GATE')
    dispatch('GET_PUBLICSAFE_RIGHT_SAFEMAP')
    dispatch('GET_PUBLICSAFE_NEWFIND')
    dispatch('getEcologyList')
    dispatch('getEcologyPoints')
    dispatch('getEcologyConvenient')
    dispatch('getEcologyPhoto')
    dispatch('getElevCount')
    dispatch('GET_BEAUTY_STREET')
    dispatch('GET_BEAUTY_HOME')
    dispatch('GET_FACILITY_CONVENIENT')
  },

  // 物业三架马车数据 （缺交叉任职数）
  async getPropertySummary({ commit }: Method): Promise<void> {
    const {
      GET_COMMITTEE: url1,
      GET_INDUSTRY_AUTHORITY: url2,
      GET_COMPANY: url3,
    } = api
    const [num1, num2, num3] = await Promise.all(
      [url1, url2, url3].map(async (url) => {
        return (await ajax.get({ url, params: { pageSize: 1 } })).data.totalRows
      })
    )
    commit('SET_PROPERTY_SUMMARY', { num1: +num1, num2: +num2, num3: +num3 })
  },

  // 公共服务 - 门岗值守 - 社会物业和直管公房数据
  async GET_PUBLICSAFE_NEWFIND({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_PUBLICSAFE_NEWFIND }))
      .data
    const obj = {
      done: 0,
      doing: 0,
      find: 0,
      newFind: content.newDiscovery,
    }
    function format(params: any) {
      params.forEach((item: any) => {
        obj.find += item.num
        switch (item.status) {
          case '已结案':
            obj.done = item.num
            break
          case '待处置':
            obj.find = item.num
            break
          default:
            break
        }
      })
    }
    format(content.caseNum)

    commit('SET_PUBLICSAFE_NEWFIND', obj)
  },

  // 公共服务 - 门岗值守 - 社会物业和直管公房数据
  async GET_PUBLICSAFE_RIGHT_GATE({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_PUBLICSAFE_RIGHT_GATE }))
      .data
    const shehuiwuye: any[] = []
    const publicHouse: any[] = []
    function formatData(arr: any[], obj: { [x: string]: any }) {
      for (const k in obj) {
        switch (k) {
          case 'isWatch':
            arr.push({
              index: 3,
              name: '值守处',
              value: obj[k] || 0,
            })
            break
          case 'isClosed':
            arr.push({
              index: 1,
              name: '已封闭',
              value: obj[k] || 0,
            })
            break
          case 'addrNum':
            arr.push({
              index: 0,
              name: '出入口',
              value: obj[k] || 0,
            })
            break
          case 'isSentry':
            arr.push({
              index: 2,
              name: '有门岗处',
              value: obj[k] || 0,
            })
            break

          default:
            break
        }
      }
      arr.sort((a, b) => {
        return a.index - b.index
      })
    }
    formatData(shehuiwuye, content.property)
    formatData(publicHouse, content.publicHouse)
    commit('SET_PUBLICSAFE_GATESENTRY_SHEHUIWUYE', shehuiwuye)
    commit('SET_PUBLICSAFE_GATESENTRY_ZHIGUANGONGFANG', publicHouse)
  },

  // 公共安全 - 门岗值守 - 平安地图
  async GET_PUBLICSAFE_RIGHT_SAFEMAP({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_PUBLICSAFE_RIGHT_SAFEMAP,
        params: { pageSize: 1000 },
      })
    ).data
    commit('SET_PUBLICSAFE_SAFEMAP', content)
  },

  // 公共服务 - 实有房屋
  async GET_PUBLICSAFE_HOUSE({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_PUBLICSAFE_HOUSE })).data
    commit('SET_PUBLICSAFE_HOUSE', content)
    const obj = {
      spf: 0,
      other: 0,
      zggf: 0,
    }
    content.stKind.forEach((item: { stKindName: string; totHous: number }) => {
      switch (item.stKindName) {
        case '商品房':
          obj.spf = item.totHous
          break
        case '直管公房':
          obj.zggf = item.totHous
          break
        default:
          obj.other += item.totHous
          break
      }
    })
    commit('SET_PUBLICSAFE_HOUSE_STKIND', content.stKind)
    commit('SET_PUBLICSAFE_HOUSE_STKIND', obj)
  },

  // 公共服务 - 非居房屋
  async GET_PUBLICSAFE_NONRESIDENT({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_NONRESIDENT })
    ).data
    commit('SET_PUBLICSAFE_NONRESIDENT', content)
  },

  // 公共服务 - 实有单位
  async GET_PUBLICSAFE_TRUE_COMPANY({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_TRUE_COMPANY })
    ).data
    commit('SET_PUBLICSAFE_TRUE_COMPANY', content)
  },

  // 公共服务 - 应急物资储备
  async GET_PUBLICSAFE_SOS_MATERIAL({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_SOS_MATERIAL })
    ).data
    commit('SET_PUBLICSAFE_SOS_MATERIAL', content)
  },

  // 公共服务 - 房屋外立面
  async GET_PUBLICSAFE_OUTHOUSEWALL({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_OUTHOUSEWALL })
    ).data
    console.log(content)
    const dataContent = [
      {
        checkNum: 32,
        dangerPoint: 345,
        hiddenPoint: 2355,
        outerWallDangerPoint: 22,
        outerWallFacilityDangerPoint: 323,
        outerWallFacilityHiddenPoint: 1922,
        outerWallHiddenPoint: 433,
        year: '2019',
      },
      {
        checkNum: 7,
        dangerPoint: 138,
        hiddenPoint: 750,
        outerWallDangerPoint: 72,
        outerWallFacilityDangerPoint: 66,
        outerWallFacilityHiddenPoint: 499,
        outerWallHiddenPoint: 251,
        year: '2020',
      },
      {
        checkNum: 1405,
        dangerPoint: 0,
        hiddenPoint: 210,
        outerWallDangerPoint: 1,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 89,
        outerWallHiddenPoint: 124,
        year: '2021',
      },
      {
        checkNum: 2308,
        dangerPoint: 0,
        hiddenPoint: 122,
        outerWallDangerPoint: 1,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 89,
        outerWallHiddenPoint: 124,
        year: '2022',
      },
    ]
    // commit('SET_PUBLICSAFE_OUTHOUSEWALL', content)
    commit('SET_PUBLICSAFE_OUTHOUSEWALL', dataContent)
  },

  // 公共安全 - 重点关注楼宇
  async GET_PUBLICSAFE_BUILDINGS({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_PUBLICSAFE_BUILDINGS,
        params: { pageSize: 9000 },
      })
    ).data
    const dataNowArr = [
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '福申大楼',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '振兴大楼',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '振华大楼',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '紫华大楼',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '威海大楼',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '金色家园7~9号',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '上海滩新昌城6号',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '重庆北路177弄52-56双号',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '威海路155弄20号',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '广东路543',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '北京西路240弄1-3号',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '浙江中路141号',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
      {
        buildYear: '1993 年',
        checkResult:
          '1) 中信福申大楼为 19 层住宅楼，房屋一层为商铺或功能用房，二至十九层为\n住宅，屋面为上人屋面。大楼主体结构体系为钢筋混凝土剪力墙结构。大楼外立\n面采用暗红色瓷砖饰面，屋面主要为防水卷材饰面。\n2) 对外立面墙体的检测结果表明，除一层外墙局部存在细裂缝，机房墙顶细裂\n缝外，大楼外立面墙体总体无明显裂缝、空鼓、剥落及风化情况。\n3) 大楼外立面附加设施主要存在问题如下：个别空调外机杆件表面锈蚀、个别\n福申大楼外立面及屋面\n附加设施安全排查报告\n第10页 共 41 页\n同济大学房屋质量检测站\n上海市四平路 1239 号，200092\n空调支架与墙体锚固处存在锈蚀液流出迹象、多个空调外罩杆件节点损坏或杆件\n缺失、个别外罩与墙体锚固处存在锈蚀液流出迹象、个别晾衣架杆件轻微锈蚀、\n个别窗台花架无底部斜撑杆、电视信号锅的杆件与墙体连接锚栓设置不合理。\n4) 屋面检测结果表明，屋面机房局部墙顶存在水平裂缝，其余墙体无明显裂缝、\n空鼓、剥落及风化情况。\n5) 屋面附加设施主要存在问题如下：机房北侧彩钢板屋面和机房东侧搭建阳光\n棚为后期增设，未经正规设计和施工；屋面堆放废弃的电视信号锅和彩钢板，与\n屋面之间无固定措施。\n6) 房屋外立面及屋面附加设施共发现明显安全隐患点 59 处，其中明显危险点\n38 处，建议对目前存在的安全隐患点有针对性地采取必要的维修处理，及时排\n除房屋存在的安全隐患点和危险点。维修和解危应由专业单位出具处理方案，在\n专业人员的统一指导下实施。\n7) 外立面破损空调外罩占全部外罩的比例约为 1/4，建议对全部空调外罩进行\n维修或更换处理。\n8) 建议拆除或加固外立面附加的信号锅及无斜撑杆的窗台花架。\n9) 建议清理屋面废弃的彩钢板等轻质片状杂物，防止被大风吹至空中后坠落。\n10) 本次外立面排查采用目测法，可能存在未查明的隐患情况，建议对外墙面采\n用红外热像法等方法进行全面检测。',
        cmtId: '0',
        cmtName: null,
        constructArea: '9000m2',
        dangerPoint: 38,
        floor: '十九层',
        hiddenPoint: 55,
        houseAddr: '黄浦区湖北路 20 号',
        id: '521492412747423745',
        inspectionDate: '2019.7.21',
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 38,
        outerWallFacilityHiddenPoint: 55,
        outerWallHiddenPoint: 0,
        planeSituation: '矩形组合',
        projectName: '广东路475',
        remark: ' 导出地址：湖北路',
        sectId: '120302190051186',
        structureType: '剪力墙结构',
        useType: '住 宅',
        year: '2022',
      },
    ]
    const newArr = content.concat(dataNowArr)
    commit('SET_PUBLICSAFE_BUILDINGS', newArr)
    // commit('SET_PUBLICSAFE_BUILDINGS', content)
  },

  // 公共服务 - 房屋外立面饼图
  async GET_PUBLICSAFE_PIEDATA({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_PUBLICSAFE_PIEDATA }))
      .data
    console.log(content)
    const mianData = [
      {
        outerWallDangerPoint: 7,
        outerWallFacilityDangerPoint: 8,
        outerWallFacilityHiddenPoint: 34,
        outerWallHiddenPoint: 41,
        workstationName: '第一综合网格工作站（武胜路）',
        year: '2019',
      },
      {
        outerWallDangerPoint: 12,
        outerWallFacilityDangerPoint: 58,
        outerWallFacilityHiddenPoint: 408,
        outerWallHiddenPoint: 93,
        workstationName: '第三综合网格工作站（牯岭路）',
        year: '2019',
      },
      {
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 18,
        outerWallFacilityHiddenPoint: 124,
        outerWallHiddenPoint: 17,
        workstationName: '第二综合网格工作站（厦门路）',
        year: '2019',
      },
      {
        outerWallDangerPoint: 2,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 0,
        outerWallHiddenPoint: 7,
        workstationName: '第一综合网格工作站（武胜路）',
        year: '2020',
      },
      {
        outerWallDangerPoint: 21,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 0,
        outerWallHiddenPoint: 133,
        workstationName: '第三综合网格工作站（牯岭路）',
        year: '2020',
      },
      {
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 17,
        outerWallFacilityHiddenPoint: 342,
        outerWallHiddenPoint: 31,
        workstationName: '第二综合网格工作站（厦门路）',
        year: '2020',
      },
      {
        outerWallDangerPoint: 1,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 5,
        outerWallHiddenPoint: 8,
        workstationName: '第一综合网格工作站（武胜路）',
        year: '2021',
      },
      {
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 12,
        outerWallHiddenPoint: 10,
        workstationName: '第三综合网格工作站（牯岭路）',
        year: '2021',
      },
      {
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 31,
        outerWallHiddenPoint: 56,
        workstationName: '第二综合网格工作站（厦门路）',
        year: '2021',
      },
      {
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 7,
        outerWallHiddenPoint: 16,
        workstationName: '第一综合网格工作站（武胜路）',
        year: '2022',
      },
      {
        outerWallDangerPoint: 0,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 10,
        outerWallHiddenPoint: 19,
        workstationName: '第三综合网格工作站（牯岭路）',
        year: '2022',
      },
      {
        outerWallDangerPoint: 1,
        outerWallFacilityDangerPoint: 0,
        outerWallFacilityHiddenPoint: 25,
        outerWallHiddenPoint: 44,
        workstationName: '第二综合网格工作站（厦门路）',
        year: '2022',
      },
    ]

    // commit('SET_PUBLICSAFE_PIEDATA', content)
    commit('SET_PUBLICSAFE_PIEDATA', mianData)
  },

  /** 公共服务 - 生态 */
  async getEcologyList({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_ECOLOGY_LIST })).data
    commit('SET_ECOLOGY_LIST', content)
  },
  async getEcologyPoints({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_ECOLOGY_POINTS,
        params: { pageSize: 1000 },
      })
    ).data
    const result = [
      ...(content || []).map((item: any) => {
        switch (item.labelName) {
          case '衣':
            item.icon = yi
            item._type = 'yi'
            break
          case '食':
            item.icon = shi
            item._type = 'shi'
            break
          case '住':
            item.icon = zhu
            item._type = 'zhu'
            break
          case '行':
            item.icon = xing
            item._type = 'xing'
            break
          // case '医':
          //   item.icon = yi2
          //   item._type = 'other'
          //   break
          // case '学':
          //   item.icon = xue
          //   item._type = 'other'
          //   break
          // case '商':
          //   item.icon = shang
          //   item._type = 'other'
          //   break
          // case '政':
          //   item.icon = zheng
          //   item._type = 'other'
          //   break
          default:
            item.icon = other
            item._type = 'other'
            break
        }
        item.size = [30, 35]
        if (item.stAddr === '大沽路123号') {
          item.icon = smStar
          item.size = 20
          item._type = 'govern'
        }
        if (item.stAddr === '人民大道200号') {
          item.icon = star
          item.size = 20
          item._type = 'govern'
        }
        return item
      }),
    ]
    const waterPoints = (
      (
        await ajax.get({
          url: api.GET_MARKETS,
          params: { labelName: '易积水点位', pageSize: 10000 },
        })
      )?.data?.content || []
    )
      .map((item: any) => {
        item.icon = water
        item.size = [30, 35]
        item._type = 'water'
        return item
      })
      .filter((item: any) => item.x && item.y)
    const rangePaths = (
      (
        await ajax.get({
          url: api.GET_MARKETS,
          params: { labelName: '拆迁范围', pageSize: 10000 },
        })
      )?.data?.content || []
    ).map((item: any) => {
      item._type = 'range'
      if (item.gis) {
        const path = JSON.parse(item.gis)
        item.path = path.map((e: any) => [+e.x, +e.y])
      }
      return item
    })
    const landMarkers = (
      (
        await ajax.get({
          url: api.GET_MARKETS,
          params: { labelName_l: '地标性建筑', pageSize: 10000 },
        })
      )?.data?.content || []
    )
      .map((item: any) => {
        item.icon = land
        item.size = [30, 35]
        item._type = 'sign'
        return item
      })
      .filter((item: any) => item.x && item.y)
    const historyPoints = (
      (
        await ajax.get({
          url: api.GET_MARKETS,
          params: { labelName_l: '历史保护建筑', pageSize: 10000 },
        })
      )?.data?.content || []
    )
      .map((item: any) => {
        item.icon = history
        item.size = [30, 35]
        item._type = 'history'
        return item
      })
      .filter((item: any) => item.x && item.y)
    const oldPoints = (
      (
        await ajax.get({
          url: api.GET_FOR_OLD,
          params: { pageSize: 10000 },
        })
      )?.data?.content || []
    )
      .map((item: any) => {
        item.icon = old
        item.size = [30, 35]
        item._type = 'old'
        return item
      })
      .filter((item: any) => item.x && item.y)
    commit('SET_ECOLOGY_POINTS', [
      ...result,
      ...waterPoints,
      ...rangePaths,
      ...landMarkers,
      ...historyPoints,
      ...oldPoints,
    ])
  },
  async getEcologyConvenient({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_ECOLOGY_CONVENIENT }))
      .data
    commit('SET_ECOLOGY_CONVENIENT', content)
  },
  async getEcologyPhoto({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_ECOLOGY_PHOTO,
        params: { pageNo: 1, pageSize: 1000 },
      })
    ).data
    commit('SET_ECOLOGY_PHOTO', content)
  },
  async getElevCount({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_ELEV_COUNT })).data
    commit('SET_ELEV_COUNT', content)
  },

  // 左侧公共 - 指挥体系
  async GET_PUBLICSAFE_COMMANDSYSTEM({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_COMMANDSYSTEM })
    ).data
    const { commander = '', deputyCommander = '' } =
      (await ajax.get({ url: api.GET_PUBLICSAFE_MASTER }))?.data?.content || {}

    commit('SET_PUBLICSAFE_COMMANDSYSTEM', {
      commander,
      deputyCommander,
      list: content || [],
    })
  },

  // 左侧公共 - 网格工作站
  async GET_PUBLICSAFE_STREETPOWER({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_PUBLICSAFE_STREETPOWER })
    ).data
    const { content: gridPowerList } = (
      await ajax.get({ url: api.GET_GRIDPOWER, params: { pageSize: 1000 } })
    ).data
    content.forEach((item: any) => {
      item.gridPower =
        gridPowerList.filter((e: any) => e.workstationId == item.id) || []
    })
    commit('SET_PUBLICSAFE_STREETPOWER', content || [])
  },

  // 左侧公共 - 党建
  async GET_PUBLICSAFE_PARTY({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_PUBLICSAFE_PARTY })).data
    commit('SET_PUBLICSAFE_PARTY', content)
  },

  // 左侧公共 - 经济
  async GET_PUBLICSAFE_ECONOMIC({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_PUBLICSAFE_ECONOMIC }))
      .data
    commit('SET_PUBLICSAFE_ECONOMIC', content)
  },

  /** 小区屏 */
  initCommunityData({ dispatch }: Method, id: string): void {
    dispatch('getCommunityInfo', id)
    dispatch('getIssueList', id)
    dispatch('getScoreIssue', id)
    dispatch('getCombineList', id)
  },
  async getCommunityInfo({ commit }: Method, id: string): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_COMMUNITY_INFO,
      })
    ).data
    commit(
      'SET_COMMUNITY_INFO',
      content.find((item: any) => item.id === id)
    )
  },
  async getIssueList({ commit }: Method, id: string): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_ISSUE_LIST,
        params: { bigscreenCommunityId: id },
      })
    ).data
    commit('SET_ISSUE_DATA', content)
  },
  async getScoreIssue({ commit }: Method, id: string): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_SCORE_ISSUE,
        params: { bigscreenCommunityId: id },
      })
    ).data
    commit('SET_SCORE_ISSUE', content)
  },
  async getCombineList({ commit }: Method, id: string): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_COMBINE_LIST,
        params: { bigscreenCommunityId: id, pageSize: 200 },
      })
    ).data
    commit('SET_COMBINE_DATA', content)
  },

  /** 工作站 */
  initStationData({ dispatch }: Method, id: string): void {
    if (!id) return
    dispatch('getStationById', id)
    dispatch('getDutySum', id)
    dispatch('getOldService', id)
    dispatch('getLifeConvenient', id)
  },
  async getStationById({ commit }: Method, id: string): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_STATION, params: { id } })
    ).data
    commit('SET_STATION', content && content[0])
  },
  async getDutySum({ commit }: Method, gridId: string): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_DUTY_SUM, params: { gridId } })
    ).data
    commit('SET_DUTY_SUM', content)
  },
  async getDutyList(
    { commit }: Method,
    params: { [key: string]: string | number }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_LIST,
        params,
      })
    ).data
    commit('SET_DUTY_LIST', content)
  },
  async getDutyRank(
    { commit }: Method,
    params: { [key: string]: string }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_RANK,
        params,
      })
    ).data
    commit('SET_DUTY_RANK', content)
  },
  async getDutyEvents(
    { commit }: Method,
    params: { [key: string]: string }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_EVENTS,
        params,
      })
    ).data
    commit('SET_DUTY_EVENTS', content)
  },
  async getDutyPlaces(
    { commit }: Method,
    params: { [key: string]: string }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_PLACES,
        params,
      })
    ).data
    commit('SET_DUTY_PLACES', content)
  },
  async getDutyRanking(
    { commit }: Method,
    params: { [key: string]: string }
  ): Promise<void> {
    if (!params.gridId) return
    const { content } = (
      await ajax.get({
        url: api.GET_DUTY_RANKING,
        params,
      })
    ).data
    commit('SET_DUTY_RANKING', content)
  },
  async getOldService({ commit }: Method, id: string): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_OLD_SERVICE,
        params: {
          workstationId: id,
        },
      })
    ).data
    commit('SET_OLD_SERVICE', content)
  },
  async getLifeConvenient({ commit }: Method, id: string): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_LIFE_CONVENIENT,
        params: {
          workstationId: id,
        },
      })
    ).data
    commit('SET_LIFE_CONVENIENT', content)
  },

  /** 公共管理 */
  // 业务入口
  async GET_ENTRY({ commit }: Method): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_ENTRY })).data
    commit('SET_ENTRY', content)
  },

  async GET_YOUSUBIDA_RANK({ commit }: Method): Promise<void> {
    // 有诉必答 - 占比
    const { content } = (await ajax.get({ url: api.GET_YOUSUBIDA_RANK })).data
    commit('SET_YOUSUBIDA_RANK', content)
  },
  async GET_YOUSUBIDA_CLASSIFICATION_RANK({ commit }: Method): Promise<void> {
    // 有诉必答 - 分类排行
    const { content } = (
      await ajax.get({
        url: api.GET_YOUSUBIDA_CLASSIFICATION_RANK,
      })
    ).data
    commit('SET_YOUSUBIDA_CLASSIFICATION_RANK', content)
  },
  async GET_URGENTCASE(
    { commit }: Method,
    params: {
      [key: string]: unknown
    }
  ): Promise<void> {
    // 有诉必答 - 紧急案件
    const { content } = (
      await ajax.get({
        url: api.GET_URGENTCASE,
        params,
      })
    ).data
    commit('SET_URGENTCASE', content)
  },
  async GET_TODAYCASE(
    { commit }: Method,
    params: {
      [key: string]: string
    }
  ): Promise<void> {
    // 有求必应 - 今日案件数
    const { content } = (
      await ajax.get({
        url: api.GET_TODAYCASE,
        params,
      })
    ).data
    commit('SET_TODAYCASE', content)
  },
  async GET_STAGECASE(
    { commit }: Method,
    params: {
      [key: string]: string
    }
  ): Promise<void> {
    // 有求必应 - 各阶段案件数
    const { content } = (
      await ajax.get({
        url: api.GET_STAGECASE,
        params,
      })
    ).data
    commit('SET_STAGECASE', content)
  },
  async GET_WORKSTATION(
    { commit }: Method,
    params: {
      [key: string]: string
    }
  ): Promise<void> {
    // 有求必应 - 工作站分类
    const { content } = (
      await ajax.get({
        url: api.GET_WORKSTATION,
        params,
      })
    ).data
    commit('SET_WORKSTATION', content)

    const result = content?.find(
      // 金字塔为当天数据
      (item: any) => item.date === dayjs().format('YYYY-MM-DD')
    )?.statistical || {
      oneDisposalNum: 0,
      oneNum: 0,
      twoDisposalNum: 0,
      twoNum: 0,
      threeDisposalNum: 0,
      threeNum: 0,
    }

    commit('SET_WORKSTATION_PIEDATA', result)
  },
  async GET_TRACKEVENT(
    { commit }: Method,
    params: {
      [key: string]: unknown
    }
  ): Promise<void> {
    // 有求必应 - 事件跟踪
    const { content } = (
      await ajax.get({
        url: api.GET_TRACKEVENT,
        params,
      })
    ).data
    commit('SET_TRACKEVENT', content)
  },
  async GET_CASE_CLASSIFICATION_RANK(
    { commit }: Method,
    params: {
      [key: string]: unknown
    }
  ): Promise<void> {
    // 案件分析 - 分类排行
    const { content } = (
      await ajax.get({
        url: api.GET_CASE_CLASSIFICATION_RANK,
        params,
      })
    ).data
    commit('SET_CASE_CLASSIFICATION_RANK', content)
  },
  async GET_MOREHAPPEN_ADDR(
    { commit }: Method,
    params: {
      [key: string]: string
    }
  ): Promise<void> {
    // 案件分析 - 多发地点
    const { content } = (
      await ajax.get({
        url: api.GET_MOREHAPPEN_ADDR,
        params,
      })
    ).data
    commit('SET_MOREHAPPEN_ADDR', content)
  },

  //响应度
  async GET_RESPONSIVITY({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_RESPONSIVITY,
      })
    ).data
    commit('SET_RESPONSIVITY', content)
  },

  async GET_BEAUTY_STREET({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_BEAUTY_STREET,
        params: { pageSize: 10000 },
      })
    ).data
    commit('SET_BEAUTY_STREET', content)
  },
  async GET_BEAUTY_HOME({ commit }: Method): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_BEAUTY_HOME,
        params: { pageSize: 10000 },
      })
    ).data
    commit('SET_BEAUTY_HOME', content)
  },

  async GET_FACILITY_CONVENIENT({ commit }: Method): Promise<void> {
    const result = {
      为老:
        (
          await ajax.get({
            url: api.GET_FOR_OLD,
            params: { pageSize: 10000 },
          })
        )?.data?.content || [],
      菜场:
        (
          await ajax.get({
            url: api.GET_MARKETS,
            params: { labelName: '菜场', pageSize: 10000 },
          })
        )?.data?.content || [],
      便利店:
        (
          await ajax.get({
            url: api.GET_MARKETS,
            params: { labelName: '便利店', pageSize: 10000 },
          })
        )?.data?.content || [],
      电话亭:
        (
          await ajax.get({
            url: api.GET_MARKETS,
            params: { labelName: '电话亭', pageSize: 10000 },
          })
        )?.data?.content || [],
      餐车:
        (
          await ajax.get({
            url: api.GET_MARKETS,
            params: { labelName: '餐车', pageSize: 10000 },
          })
        )?.data?.content || [],
      公厕:
        (
          await ajax.get({
            url: api.GET_MARKETS,
            params: { labelName: '公厕', pageSize: 10000 },
          })
        )?.data?.content || [],
      街面废物箱:
        (
          await ajax.get({
            url: api.GET_MARKETS,
            params: { labelName: '街面废物箱', pageSize: 10000 },
          })
        )?.data?.content || [],
      垃圾箱房:
        (
          await ajax.get({
            url: api.GET_MARKETS,
            params: { labelName: '垃圾箱房', pageSize: 10000 },
          })
        )?.data?.content || [],
      药房:
        (
          await ajax.get({
            url: api.GET_MARKETS,
            params: { labelName: '药房', pageSize: 10000 },
          })
        )?.data?.content || [],
    }
    commit('SET_FACILITY_CONVENIENT', result)
  },

  async GET_COMMUNITY_PATHS({ commit }: Method): Promise<void> {
    ajax
      .get({
        url: api.GET_COMMUNITY_PATH,
        params: {
          pageSize: 9999,
        },
      })
      .then((res) => {
        const result = (res?.data?.content || []).map((item: any) => {
          if (item.gis) {
            const path = JSON.parse(item.gis)
            item.path = path.map((e: any) => [+e.x, +e.y])
          }
          return item
        })
        commit('SET_COMMUNITY_PATHS', result)
      })
  },
}
