import { ref, watch, computed } from 'vue'
import { ajax, api } from '@/ajax'
import store from '@/store'

export default function useSwitchMap(map: any): any {
  const curMapType = computed(() => store.state.curMapType)
  const curViewType = computed(() => store.state.curView.type)
  watch(
    () => curMapType.value,
    (type) => {
      if (!map.value) return
      map.value.initMap({ viewMode: type })
    },
    { immediate: true }
  )
  watch(
    () => store.state.showCommunityPoints,
    (val) => {
      val ? setPointsAndBoundary(curViewType.value) : map.value.hideCommunity()
    }
  )
  watch(
    () => curViewType.value,
    (type) => {
      store.commit('SET_SHOW_COMMUNITY_POINTS', false)
      setPointsAndBoundary(type)
      if (areaLines.value && areaLines.value.length > 0) {
        map.value.remove(areaLines.value)
      }
      if (curMapType.value === '2D') return
      store.commit('SET_MAP_TYPE', '2D')
    }
  )
  let boundary: any = null
  // 根据条件显示小区点和添加边界
  function setPointsAndBoundary(type: string) {
    boundary && boundary.remove()
    const show = store.state.showCommunityPoints
    switch (type) {
      case 'work1':
        show && showPoints({ gridId: store.state.workArea1.id })
        boundary = map.value.addBoundary({
          type: 'jwh_boundary',
          name: '第一',
          color: 'rgba(0,0,0,0)',
        })
        map.value.focus(...store.state.workArea1.center, 8)
        break
      case 'work2':
        show && showPoints({ gridId: store.state.workArea2.id })
        boundary = map.value.addBoundary({
          type: 'jwh_boundary',
          name: '第二',
          color: 'rgba(0,0,0,0)',
        })
        map.value.focus(...store.state.workArea2.center, 8)
        break
      case 'work3':
        show && showPoints({ gridId: store.state.workArea3.id })
        boundary = map.value.addBoundary({
          type: 'jwh_boundary',
          name: '第三',
          color: 'rgba(0,0,0,0)',
        })
        map.value.focus(...store.state.workArea3.center, 8)
        break
      case 'street':
        show && showPoints()
        boundary = map.value.addBoundary({
          name: '南京东路街道',
          color: 'rgba(0,0,0,0)',
        })
        map.value.focus(207.9006154792994, 71.67111885454233, 8)
        break
      default:
        break
    }
  }
  async function showPoints(params = {}) {
    const { content } = (
      await ajax.get({ url: api.GET_COMMUNITY_IDS, params })
    ).data
    map.value.setFilter(content)
    map.value.showCommunity()
  }

  const handleMapComplete = async () => {
    setPointsAndBoundary(curViewType.value)
    if (curMapType.value === '3D') {
      if (curViewType.value === 'work1') {
        map.value.layer('model_white_zw').visible = false
        map.value.layer('model_white_dyjd').visible = true // 第一街道名
      } else {
        map.value.layer('model_white_zw').visible = true
        map.value.layer('model_white_dyjd').visible = false
      }
    }
  }

  // 工作站勾边
  const areaLines = ref([])
  const selectArea = (e: any) => {
    map.value.remove(areaLines.value)
    areaLines.value = e.map(
      (
        name:
          | 'workArea1'
          | 'workArea2'
          | 'workArea3'
          | 'zhenxing'
          | 'weihai'
          | null
      ) => {
        if (!name) return
        let color = '#FF6161'
        if (name.indexOf('workArea') >= 0) {
          color = '#FFCE34'
        }
        return map.value.addPolyLine({
          paths: store.state[name].paths,
          strokeColor: color,
        })
      }
    )
  }
  const handleZoom = (type: string) => {
    map.value.zoom(type)
  }
  return {
    handleMapComplete,
    selectArea,
    handleZoom,
  }
}
