import { GlobalStateProps, ThemeType, ViewType } from './index'

export default {
  SET_LOADING(state: GlobalStateProps, val: boolean): void {
    state.showLoading = val
  },
  SET_CURRENT_VIEW(state: GlobalStateProps, val: ViewType): void {
    state.curView = val
  },
  SET_CURRENT_THEME(state: GlobalStateProps, val: ThemeType): void {
    state.curTheme = val
  },
  SET_PROPERTY_SUMMARY(
    state: GlobalStateProps,
    val: { [key: string]: number }
  ): void {
    state.propertySummary = val
  },
  SET_CASE_LIST(state: GlobalStateProps, data: unknown[]): void {
    state.caseList = data
  },
  SET_MUTATION_LIST(state: GlobalStateProps, data: unknown[]): void {
    state.stationList = data
  },
}
