import { GlobalStateProps, ThemeType, ViewType } from './index'

export default {
  SET_LOADING(state: GlobalStateProps, val: boolean): void {
    state.showLoading = val
  },
  SET_CURRENT_VIEW(state: GlobalStateProps, val: ViewType): void {
    state.curView = val
  },
  SET_CURRENT_THEME(state: GlobalStateProps, val: ThemeType): void {
    state.curTheme = val
  },
  SET_PROPERTY_SUMMARY(
    state: GlobalStateProps,
    val: { [key: string]: number }
  ): void {
    state.propertySummary = val
  },
  SET_CASE_LIST(state: GlobalStateProps, data: unknown[]): void {
    state.caseList = data
  },
  SET_MUTATION_LIST(state: GlobalStateProps, data: unknown[]): void {
    state.stationList = data
  },
  SET_PUBLICSAFE_GATESENTRY_SHEHUIWUYE(
    // 公共安全-门岗值守-社会物业
    state: GlobalStateProps,
    data: { [key: string]: number }
  ): void {
    state.pubulicSafeGateSenteryShehuiwuye = data
  },
  SET_PUBLICSAFE_GATESENTRY_ZHIGUANGONGFANG(
    // 公共安全-门岗值守-直管公房
    state: GlobalStateProps,
    data: { [key: string]: number }
  ): void {
    state.pubulicSafeGateSenteryZhiguangongfang = data
  },
  SET_PUBLICSAFE_SAFEMAP(
    // 公共安全-平安地图
    state: GlobalStateProps,
    data: unknown[]
  ): void {
    state.pubulicSafeMap = data
  },
  SET_PUBLICSAFE_TRUE_PEOPLE(
    // 公共安全-实有人口
    state: GlobalStateProps,
    data: { [key: string]: number }
  ): void {
    state.pubulicSafeTruePeople = data
  },
  SET_PUBLICSAFE_HOUSE(
    // 公共安全-居住房屋
    state: GlobalStateProps,
    data: { [key: string]: any }
  ): void {
    state.pubulicSafeHouse = data
  },
  SET_PUBLICSAFE_NONRESIDENT(
    // 公共安全-非居房屋
    state: GlobalStateProps,
    data: { [key: string]: any }
  ): void {
    state.pubulicSafeNonResident = data
  },
  SET_PUBLICSAFE_HOUSE_STKIND(
    // 公共安全-居住房屋-stkind
    state: GlobalStateProps,
    data: { [key: string]: number }
  ): void {
    state.pubulicSafeHouseStKind = data
  },
  SET_PUBLICSAFE_TRUE_COMPANY(
    // 公共安全-实有单位
    state: GlobalStateProps,
    data: { [key: string]: any }
  ): void {
    state.pubulicSafeTrueCompany = data
  },
  SET_PUBLICSAFE_SOS_MATERIAL(
    // 公共安全-应急物资储备
    state: GlobalStateProps,
    data: { [key: string]: any }
  ): void {
    state.pubulicSafeSOSMaterail = data
  },
  SET_PUBLICSAFE_OUTHOUSEWALL(
    // 公共安全-房屋外立面
    state: GlobalStateProps,
    data: unknown[]
  ): void {
    state.pubulicSafeOutHouseWall = data
  },
  SET_PUBLICSAFE_OUTHOUSEWALL_2019(
    // 公共安全-房屋外立面
    state: GlobalStateProps,
    data: { [key: string]: number }
  ): void {
    state.pubulicSafeOutHouseWall2019 = data
  },
  SET_PUBLICSAFE_OUTHOUSEWALL_2020(
    // 公共安全-房屋外立面
    state: GlobalStateProps,
    data: { [key: string]: number }
  ): void {
    state.pubulicSafeOutHouseWall2020 = data
  },
  SET_PUBLICSAFE_BUILDINGS(
    // 公共安全-重点关注楼宇
    state: GlobalStateProps,
    data: unknown[]
  ): void {
    state.pubulicSafeBuildings = data
  },
  SET_PUBLICSAFE_PIEDATA(
    // 公共安全-房屋外立面饼图
    state: GlobalStateProps,
    data: unknown[]
  ): void {
    state.pubulicSafePieData = data
  },
  SET_PUBLICSAFE_NEWFIND(
    // 公共安全-最新发现数
    state: GlobalStateProps,
    data: { [key: string]: number }
  ): void {
    state.pubulicSafeNewFindNum = data
  },
}
