import { createStore } from 'vuex'
import state from './state'
import mutations from './mutations'
import actions from './actions'

export type ThemeType = 'manage' | 'service' | 'safety'
export interface ViewType {
  name: string
  type: 'street' | 'work1' | 'work2' | 'work3' | 'community'
}

export interface CommunityInfoProp {
  bigscreenCommunityName: string // 小区名称
  chargingPile: number //充电桩
  totCommunity: number //小区数
  totCmp: number //物业企业数
  totForOld: number //为老设施
  parkingSpace: number //车棚
  totHous: number //总户数
  communityList: { sectName: string; sectId: string }[] // 小区列表
  icMember: unknown[] // 业委会列表
}
export interface IssueProp {
  date: string //日期
  securityScore: number //安全
  cleanScore: number //干净
  orderlyScore: number //有序
  totalScore: number //综合评分
}
export interface GlobalStateProps {
  showLoading: boolean
  curView: ViewType
  readonly viewOptions: ViewType[]
  curTheme: ThemeType
  propertySummary: { [key: string]: number }
  caseList: unknown[]
  stationList: unknown[]
  communityInfo: Partial<CommunityInfoProp>
  issueData: IssueProp[]
}
export default createStore<GlobalStateProps>({
  state,
  mutations,
  actions,
})
