import {
  GlobalStateProps,
  ThemeType,
  ViewType,
  CommunityInfoProp,
  IssueProp,
  CombineProp,
} from './index'

export default {
  SET_LOADING(state: GlobalStateProps, val: boolean): void {
    state.showLoading = val
  },
  SET_CURRENT_VIEW(state: GlobalStateProps, val: ViewType): void {
    state.curView = val
  },
  SET_CURRENT_THEME(state: GlobalStateProps, val: ThemeType): void {
    state.curTheme = val
  },
  SET_PROPERTY_SUMMARY(
    state: GlobalStateProps,
    val: { [key: string]: number }
  ): void {
    state.propertySummary = val
  },
  SET_CASE_LIST(state: GlobalStateProps, data: unknown[]): void {
    state.caseList = data
  },
  SET_STATION_LIST(state: GlobalStateProps, data: unknown[]): void {
    state.stationList = data
  },
  /** 小区页面 */
  SET_COMMUNITY_INFO(state: GlobalStateProps, data: CommunityInfoProp): void {
    state.communityInfo = data
  },
  SET_ISSUE_DATA(state: GlobalStateProps, data: IssueProp[]): void {
    state.issueData = data
  },
  SET_COMBINE_DATA(state: GlobalStateProps, data: CombineProp): void {
    state.combineData = data
  },
}
