import { ajax, api } from '@/ajax'
import { Dispatch, Commit } from 'vuex'
export default {
  initData({ dispatch }: { dispatch: Dispatch }): void {
    dispatch('getPropertySummary')
    dispatch('getCaseList')
  },
  // 物业三架马车数据 （缺交叉任职数）
  async getPropertySummary({ commit }: { commit: Commit }): Promise<void> {
    const {
      GET_COMMITTEE: url1,
      GET_INDUSTRY_AUTHORITY: url2,
      GET_COMPANY: url3,
    } = api
    const [num1, num2, num3] = await Promise.all(
      [url1, url2, url3].map(async (url) => {
        return (await ajax.get({ url, params: { pageSize: 1 } })).data.totalRows
      })
    )
    commit('SET_PROPERTY_SUMMARY', { num1: +num1, num2: +num2, num3: +num3 })
  },

  // 案件汇总列表
  async getCaseList({ commit }: { commit: Commit }): Promise<void> {
    const { content } = (
      await ajax.get({ url: api.GET_CASE, params: { pageSize: 100 } })
    ).data
    commit('SET_CASE_LIST', content)
  },

  // 工作站列表
  async getStation({ commit }: { commit: Commit }): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_STATION })).data
    commit('SET_STATION_LIST', content)
  },

  /** 小区屏 */
  initCommunityData({ dispatch }: { dispatch: Dispatch }, id: string): void {
    dispatch('getCommunityInfo', id)
    dispatch('getIssueList', id)
    dispatch('getCombineList', id)
  },
  async getCommunityInfo({ commit }: { commit: Commit }): Promise<void> {
    const { content } = (await ajax.get({ url: api.GET_COMMUNITY_INFO })).data
    commit('SET_COMMUNITY_INFO', content[1])
  },
  async getIssueList(
    { commit }: { commit: Commit },
    id: string
  ): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_ISSUE_LIST,
        params: { bigscreenCommunityId: id },
      })
    ).data
    commit('SET_ISSUE_DATA', content)
  },
  async getCombineList(
    { commit }: { commit: Commit },
    id: string
  ): Promise<void> {
    const { content } = (
      await ajax.get({
        url: api.GET_COMBINE_LIST,
        params: { bigscreenCommunityId: id },
      })
    ).data
    commit('SET_COMBINE_DATA', content)
  },
}
