let BASE_URL = ''
switch (process.env.NODE_ENV) {
  case 'production':
    BASE_URL = 'http://nandong-dev.omniview.pro/api'
    break
  default:
    BASE_URL = '/api'
}

export default {
  BASE_URL,
  GET_BUILDING: '/service-basicdatasync-ddd/building', // 门牌幢列表
  GET_STATION: '/service-special-nandong/workstations', // 工作站列表
  GET_INDUSTRY_AUTHORITY: '/service-basicdatasync-ddd/indCous', // 业委会列表
  GET_COMMITTEE: '/service-basicdatasync-ddd/residentsCommittees', // 居委会列表
  GET_COMPANY: '/service-basicdatasync-ddd/propCompanies', // 物业列表
  GET_CASE: '/service-special-nandong/compairs', // 案件汇总列表
  GET_PUBLICSAFE_RIGHT_GATE: '/service-special-nandong/ironGate/statistical', // 公共安全-右侧-门岗分布
  GET_PUBLICSAFE_RIGHT_SAFEMAP: '/service-special-nandong/peaceMaps', // 公共安全-右侧-平安地图
  GET_PUBLICSAFE_TRUE_PEOPLE: '/service-special-nandong/personnel/statistical', // 公共安全-右侧-实有人口
  GET_PUBLICSAFE_HOUSE: '/service-basicdatasync-ddd/resource/count', // 公共安全-右侧-居住房屋
  GET_PUBLICSAFE_NONRESIDENT:
    '/service-basicdatasync-ddd/nonResident/statistical', // 公共安全-右侧-非居房屋
  GET_PUBLICSAFE_TRUE_COMPANY: '/service-special-nandong/company/statistical', // 公共安全-右侧-实有单位
  GET_PUBLICSAFE_SOS_MATERIAL: '/service-special-nandong/emergencySupplies', // 公共安全-右侧-应急物资储备
  GET_PUBLICSAFE_OUTHOUSEWALL:
    '/service-special-nandong/inspection/statistical', // 公共安全-右侧-房屋外立面
  GET_PUBLICSAFE_BUILDINGS: '/service-special-nandong/inspections', // 公共安全-右侧-重点关注楼宇
  GET_PUBLICSAFE_PIEDATA: '/service-special-nandong/inspection/getPie', // 公共安全-右侧-房屋外立面饼图
  GET_PUBLICSAFE_NEWFIND: '/service-special-nandong/noAlert', // 公共安全-右侧-最新发现

  // 左侧公共
  GET_PUBLICSAFE_COMMANDSYSTEM: '/service-special-nandong/commandSystem', // 指挥体系
  GET_PUBLICSAFE_STREETPOWER: '/service-special-nandong/streetPower', // 网格工作站(原名街道力量)
  GET_PUBLICSAFE_PARTY: '/service-special-nandong/party', // 党建
  GET_PUBLICSAFE_ECONOMIC: '/service-special-nandong/economic', // 经济
}
