export function convertName(name: string): string {
  let userName = ''
  if (!name) return userName
  if (name.length == 2) {
    userName = name.substring(0, 1) + '*' //截取name 字符串截取第一个字符，
  } else if (name.length == 3) {
    userName = name.substring(0, 1) + '*' + name.substring(2, 3) //截取第一个和第三个字符
  } else if (name.length > 3) {
    userName = name.substring(0, 1) + '*' + '*' + name.substring(3, name.length) //截取第一个和大于第4个字符
  }
  return userName
}

export function convertIds(number: string): string {
  if (!number) return ''
  return number.replace(/(\d{6})\d*(\d{2})/, '$1**********$2')
}

export function transType(type: string): { text: string; color: string } {
  switch (type) {
    case 'fire':
      return {
        text: '消防通道占用',
        color: '#2F86EE',
      }
    case 'batteryCar':
      return {
        text: '电瓶车入梯',
        color: '#ffd400',
      }
    case 'overflowingGarbage':
      return {
        text: '垃圾满溢',
        color: '#00f2ff',
      }
    case 'groupRent':
      return {
        text: '违规租赁',
        color: '#F7933E',
      }
    case 'highFall':
      return {
        text: '高抛隐患',
        color: '#5BD5FF',
      }
    case 'ferrousGarbage':
      return {
        text: '垃圾暴露',
        color: '#4F953B',
      }
    default:
      return {
        text: '无',
        color: '#fff',
      }
  }
}

export function roomStatus(status: string): { text: string; color: string } {
  //房屋状态 0自住 1空关 2出租 3出租(群租)
  switch (status) {
    case '0':
      return {
        text: '自住',
        color: '#2F86EE',
      }
    case '1':
      return {
        text: '空关',
        color: '#00f2ff',
      }
    case '2':
      return {
        text: '出租',
        color: '#ffd400',
      }
    case '3':
      return {
        text: '出租(群租)',
        color: '#F7933E',
      }
    default:
      return {
        text: '',
        color: '#fff',
      }
  }
}
