import { createStore, CommitOptions, DispatchOptions } from 'vuex'
import state from './state'
import mutations from './mutations'
import actions from './actions'

export type ThemeType = 'manage' | 'service' | 'safety'
export interface ViewType {
  name: string
  type: string
  id?: string
}

export interface CommunityInfoProp {
  bigscreenCommunityName: string // 小区名称
  chargingPile: number //充电桩
  totCommunity: number //小区数
  totCmp: number //物业企业数
  totForOld: number //为老设施
  parkingSpace: number //车棚
  totHous: number //总户数
  communityList: { sectName: string; sectId: string }[] // 小区列表
  icMember: unknown[] // 业委会列表
  [key: string]: any
}
export interface IssueProp {
  date: string //日期
  securityScore: number //安全
  cleanScore: number //干净
  orderlyScore: number //有序
  totalScore: number //综合评分
}

export interface CombineProp {
  cleanList: { [key: string]: any }[]
  securityList: { [key: string]: any }[]
  orderlyList: { [key: string]: any }[]
  [key: string]: { [key: string]: any }[]
}

export interface DutySumProp {
  comprehensiveNum: number //综合管理数量
  comprehensiveEndNum: number //综合管理已结数量
  streetNum: number //街面管理数量
  streetEndNum: number //街面管理已结数量
  communityEndNum: number //小区管理已结数量
  communityNum: number //小区管理数量
}

export interface YousubidaRankProp {
  comprehensiveNum: 0 //综合数量
  comprehensiveDispatchNum: 0 //综合派遣数量
  streetNum: 0 //街道数量
  streetDispatchNum: 0 //街道派遣数量
  communityDispatchNum: 0 //小区数量
  communityNum: 0 //小区派遣数量
}
export interface DutyDataProp {
  week: { [key: string]: unknown }[]
  month: { [key: string]: unknown }[]
  day: { [key: string]: unknown }[]
  [key: string]: { [key: string]: any }[]
}

export interface EcologyListProp {
  labelName: string
  num: number
}

export interface EcologyPhotoProp {
  buildingName: string
  buildingType: string
  id: string
  photoUrl?: string
}

export interface ForOldProp {
  facilitiesType: string
  num: number
}

export interface ElevCountProp {
  cmtName: string
  num: number
  workstationId?: string
}

export interface ResponsivityProp {
  date: string
  statistical: {
    totalNum: number
    reachNum: number
  }
}

export interface EntryProp {
  inputName: string
  url: string
}

export interface GlobalStateProps {
  showLoading: boolean
  curView: ViewType
  curMapType: string
  curPointType: null | string
  checkedKeys: string[]
  showCommunityPoints: boolean
  readonly zhenxing: any
  readonly weihai: any
  readonly workArea1: any
  readonly workArea2: any
  readonly workArea3: any
  readonly viewOptions: ViewType[]
  readonly communityOptions: ViewType[]
  curTheme: ThemeType
  propertySummary: { [key: string]: number }
  pubulicSafeGateSenteryShehuiwuye: { [key: string]: number }[]
  pubulicSafeGateSenteryZhiguangongfang: { [key: string]: number }[]
  pubulicSafeMap: unknown[]
  pubulicSafeTruePeople: { [key: string]: number }
  pubulicSafeHouse: { [key: string]: any }
  pubulicSafeNonResident: { [key: string]: any }
  pubulicSafeHouseStKind: { [key: string]: number }
  pubulicSafeTrueCompany: { [key: string]: number }
  pubulicSafeEmergencySupplies: { [key: string]: number }
  pubulicSafeBuildings: unknown[]
  pubulicSafePieData: unknown[]
  pubulicSafeNewFindNum: { [key: string]: number }
  pubulicSafeOutHouseWall: any[]
  pubulicLeftCommandSystem: { [key: string]: any }
  pubulicLeftStreetPower: any[]
  pubulicLeftParty: { [key: string]: number }
  pubulicLeftEconomic: { [key: string]: string }

  /** 小区页面 */
  communityInfo: Partial<CommunityInfoProp>
  issueData: IssueProp[]
  scoreIssue: any
  combineData: CombineProp

  /** 工作站 */
  stationInfo: { [key: string]: unknown }
  dutySum: Partial<DutySumProp>
  dutyList: { [key: string]: any }[]
  dutyRank: Partial<DutyDataProp>
  dutyEvents: Partial<DutyDataProp>
  dutyPlaces: Partial<DutyDataProp>
  dutyRanking: Partial<DutyDataProp>

  /** 公共管理 */
  yousubidaRank: Partial<YousubidaRankProp>
  classificationRank: any[]
  urgentCase: any[]
  todayCase: { [key: string]: number }
  stageCase: { [key: string]: number }
  workstationKind: any[]
  workstationKindPiEData: { [key: string]: number }
  trackEvent: any[]
  analysisRank: Partial<DutyDataProp>
  moreHappenAddr: Partial<DutyDataProp>
  ecologyList: EcologyListProp[]
  ecologyPoints: any[]
  ecologyConvenient: EcologyListProp[]
  ecologyPhoto: EcologyPhotoProp[]
  oldService: ForOldProp[]
  lifeConvenient: EcologyListProp[]
  elevCount: ElevCountProp[]
  responsivity: ResponsivityProp[]
  entry: EntryProp[]
  emergencyPoints: any[]
  beautyStreet: any[]
  beautyHome: any[]
  facilityConvenient: any
}

/** ------------------------------------- 分隔线 --------------------------------------- */

type CutHead<Tuple extends unknown[]> = ((...args: Tuple) => unknown) extends (
  first: any,
  ...rest: infer Result
) => unknown
  ? Result
  : never

type MutationsType = typeof mutations
type CommitPayload = {
  [key in keyof MutationsType]: CutHead<Parameters<MutationsType[key]>>[0]
}
export interface Commit {
  <T extends keyof CommitPayload>(
    type: T,
    payload?: CommitPayload[T],
    options?: CommitOptions
  ): void
}
type ActionsType = typeof actions
type DispatchPayload = {
  [key in keyof ActionsType]: CutHead<Parameters<ActionsType[key]>>[0]
}
export interface Dispatch {
  <T extends keyof DispatchPayload>(
    type: T,
    payload?: DispatchPayload[T],
    options?: DispatchOptions
  ): Promise<any>
}

const store = createStore<GlobalStateProps>({
  state,
  mutations,
  actions,
})
type MyStore = Omit<typeof store, 'commit' | 'dispatch'> & {
  commit: Commit
  dispatch: Dispatch
}

export default store as MyStore
