import { ref, watch, computed } from 'vue'
import { ajax, api } from '@/ajax'
import store from '@/store'

export default function useSwitchMap(map: any) {
  const curMapType = computed(() => store.state.curMapType)
  const curViewType = computed(() => store.state.curView.type)
  watch(
    () => curMapType.value,
    (type) => {
      if (!map.value) return
      map.value.initMap({ viewMode: type })
    },
    { immediate: true }
  )
  watch(
    () => curViewType.value,
    (type) => {
      setPoints(type)
      if (curMapType.value === '2D') return
      store.commit('SET_MAP_TYPE', '2D')
    }
  )

  // 根据条件显示小区点
  function setPoints(type: string) {
    switch (type) {
      case 'work1':
        showPoints({ gridId: store.state.workArea1.id })
        map.value.focus(...store.state.workArea1.center, 7)
        break
      case 'work2':
        showPoints({ gridId: store.state.workArea2.id })
        map.value.focus(...store.state.workArea2.center, 7)
        break
      case 'work3':
        showPoints({ gridId: store.state.workArea3.id })
        map.value.focus(...store.state.workArea3.center, 7)
        break
      case 'street':
        showPoints()
        map.value.focus(1019.614669, 54.167243, 6.5)
        break
      default:
        break
    }
  }
  async function showPoints(params = {}) {
    const { content } = (
      await ajax.get({ url: api.GET_COMMUNITY_IDS, params })
    ).data
    map.value.setFilter(content)
    map.value.showCommunity()
  }

  const handleMapComplete = async () => {
    map.value.addBoundary({ name: '南京东路街道', color: 'rgba(0,0,0,0)' })
    setPoints(curViewType.value)
    if (curMapType.value === '3D') {
      if (curViewType.value === 'work1') {
        map.value.layer('model_white_zw').visible = false
        map.value.layer('model_white_dyjd').visible = true // 第一街道名
      } else {
        map.value.layer('model_white_zw').visible = true
        map.value.layer('model_white_dyjd').visible = false
      }
    }
  }

  // 工作站勾边
  const areaLines = ref([])
  const selectArea = (e: any) => {
    map.value.remove(areaLines.value)
    areaLines.value = e.map(
      (
        name:
          | 'workArea1'
          | 'workArea2'
          | 'workArea3'
          | 'zhenxing'
          | 'weihai'
          | null
      ) => {
        if (!name) return
        return map.value.addPolyLine({
          paths: store.state[name].paths,
          strokeColor: '#FF6161',
        })
      }
    )
  }
  return {
    handleMapComplete,
    selectArea,
  }
}
