import { watch, computed, nextTick } from 'vue'
import { ajax, api } from '@/ajax'
import store from '@/store'
import smStar from '@/assets/images/star-sm.png'
import star from '@/assets/images/star.png'

export default function useSwitchMap(map: any): any {
  const curMapType = computed(() => store.state.curMapType)
  const curViewType = computed(() => store.state.curView.type)
  watch(
    () => store.state.showCommunityPoints,
    (val) => {
      val ? setPointsAndBoundary(curViewType.value) : map.value.hideCommunity()
    }
  )
  watch(
    () => curViewType.value,
    (type) => {
      // store.commit('SET_SHOW_COMMUNITY_POINTS', false)
      setPointsAndBoundary(type)
      if (areaLines && areaLines.length > 0) {
        map.value.remove(areaLines)
      }
      if (curMapType.value === '3D') return
      store.commit('SET_MAP_TYPE', '3D')
    }
  )
  const boundary: any = null
  // 根据条件显示小区点和添加边界
  function setPointsAndBoundary(type: string) {
    if (!map.value) return
    // boundary && boundary.remove()
    // const show = store.state.showCommunityPoints
    // switch (type) {
    //   case 'work1':
    //     // show && showPoints({ gridId: store.state.workArea1.id })
    //     // boundary = map.value.addBoundary({
    //     //   type: 'jwh_boundary',
    //     //   name: '第一',
    //     //   color: 'rgba(0,0,0,0)',
    //     // })
    //     // map.value.focus(...store.state.workArea1.center, 8)
    //     break
    //   case 'work2':
    //     // show && showPoints({ gridId: store.state.workArea2.id })
    //     // boundary = map.value.addBoundary({
    //     //   type: 'jwh_boundary',
    //     //   name: '第二',
    //     //   color: 'rgba(0,0,0,0)',
    //     // })
    //     // map.value.focus(...store.state.workArea2.center, 8)
    //     break
    //   case 'work3':
    //     // show && showPoints({ gridId: store.state.workArea3.id })
    //     // boundary = map.value.addBoundary({
    //     //   type: 'jwh_boundary',
    //     //   name: '第三',
    //     //   color: 'rgba(0,0,0,0)',
    //     // })
    //     // map.value.focus(...store.state.workArea3.center, 8)
    //     break
    //   case 'street':
    //     // show && showPoints()
    //     // boundary = map.value.addBoundary({
    //     //   name: '南京东路街道',
    //     //   color: 'rgba(0,0,0,0)',
    //     // })
    //     // map.value.focus(207.9006154792994, 71.67111885454233, 8)
    //     break
    //   default:
    //     break
    // }
  }
  async function showPoints(params = {}) {
    const { content } = (
      await ajax.get({ url: api.GET_COMMUNITY_IDS, params })
    ).data
    map.value.setFilter(content)
    map.value.showCommunity()
  }

  // 工作站勾边
  let areaLines: any = null
  const selectArea = (e: any) => {
    map.value.remove(areaLines)
    areaLines = e.map(
      (
        name:
          | 'workArea1'
          | 'workArea2'
          | 'workArea3'
          | 'zhenxing'
          | 'weihai'
          | null
      ) => {
        if (!name) return
        let color = '#FF6161'
        if (name.indexOf('workArea') >= 0) {
          color = '#FFCE34'
        }
        return map.value.addPolyLine({
          key: name,
          paths: store.state[name].paths,
          strokeColor: color,
        })
      }
    )
  }
  const handleZoom = (type: string) => {
    map.value.zoom(type)
  }

  const curPointType = computed(() => store.state.curPointType)
  const checkedKeys = computed(() => store.state.checkedKeys)

  const handleMapComplete = async () => {
    setPointsAndBoundary(curViewType.value)
    // if (curMapType.value === '3D') {
    //   if (curViewType.value === 'work1') {
    //     map.value.layer('model_white_zw').visible = false
    //     map.value.layer('model_white_dyjd').visible = true // 第一街道名
    //   } else {
    //     map.value.layer('model_white_zw').visible = true
    //     map.value.layer('model_white_dyjd').visible = false
    //   }
    // }
    await nextTick()
    handlePoint(curPointType.value, checkedKeys.value)
  }

  // 撒点相关
  const ecologyPoints = computed(() => store.state.ecologyPoints)
  watch(
    () => ecologyPoints.value,
    (cur) => {
      handlePoint(curPointType.value, checkedKeys.value)
    },
    { immediate: true }
  )
  watch(
    [() => curPointType.value, () => checkedKeys.value],
    ([type, keys], [pastType, pastKeys]) => {
      if (type === pastType && keys.join() === pastKeys?.join()) return
      if (keys.join() !== pastKeys?.join()) {
        handlePoint(null, keys)
      } else {
        handlePoint(type, keys)
      }
    }
  )
  let mapPoints: any = null
  let moveRangePaths: any = null
  let communityPaths: any = null
  const emergencyPoints = computed(() => store.state.emergencyPoints)
  let mapEmergency: any = null
  function handlePoint(type: null | string, keys: string[]) {
    if (!map.value) return
    const {
      showCommunity,
      hideCommunity,
      addPoint,
      addPolyLine,
      remove,
    } = map.value

    if (keys.length === 0) {
      // hideCommunity()
      remove(mapPoints)
      remove(moveRangePaths)
      remove(communityPaths)
      return
    }

    const pointData = type
      ? ecologyPoints.value.filter((e) => e.labelName === type)
      : ecologyPoints.value

    // if (keys.some((key) => key === 'community')) { // 测绘院开关自带小区点
    //   showCommunity()
    // } else {
    //   hideCommunity()
    // }
    const yiPoints = pointData.filter((e) => e.labelName === '衣')
    const shiPoints = pointData.filter((e) => e.labelName === '食')
    const zhuPoints = pointData.filter((e) => e.labelName === '住')
    const xingPoints = pointData.filter((e) => e.labelName === '行')
    const otherPoints = pointData.filter((e) => e._type === 'other')
    const governPoints = pointData.filter((e) => e._type === 'govern')
    const oldPoints = pointData.filter((e) => e._type === 'old')
    const signPoints = pointData.filter((e) => e._type === 'sign')
    const historyPoints = pointData.filter((e) => e._type === 'history')
    const waterPoints = pointData.filter((e) => e._type === 'water')
    const moveRanges = pointData.filter((e) => e._type === 'range')

    remove(mapEmergency)
    remove(mapPoints)
    remove(moveRangePaths)
    remove(communityPaths)
    mapPoints = addPoint({
      key: 'map-points',
      size: 20,
      data: [
        ...(keys.some((key) => key === 'yi') ? yiPoints : []),
        ...(keys.some((key) => key === 'shi') ? shiPoints : []),
        ...(keys.some((key) => key === 'zhu') ? zhuPoints : []),
        ...(keys.some((key) => key === 'xing') ? xingPoints : []),
        ...(keys.some((key) => key === 'other') ? otherPoints : []),
        ...(keys.some((key) => key === 'old') ? oldPoints : []),
        ...(keys.some((key) => key === 'sign') ? signPoints : []),
        ...(keys.some((key) => key === 'history') ? historyPoints : []),
        ...(keys.some((key) => key === 'water') ? waterPoints : []),
        ...governPoints,
      ],
    })
    if (keys.some((key) => key === 'range')) {
      moveRangePaths = moveRanges.map((item: any, index) =>
        addPolyLine({
          key: `move-rangs${index}`,
          paths: item.path,
          strokeColor: '#f00',
        })
      )
    }
    if (keys.some((key) => key === 'community')) {
      communityPaths = store.state.communityPaths.map((item: any, index) =>
        addPolyLine({
          key: `community-path${index}`,
          paths: item.path,
          strokeColor: '#00ffdd',
        })
      )
    }
  }

  watch(
    () => emergencyPoints.value,
    (points) => {
      if (points.length === 0 || !map.value) return
      const { addPoint, remove } = map.value
      remove(mapEmergency)
      remove(mapPoints)
      store.commit('SET_CHECKED_KEYS', [])
      mapEmergency = addPoint({
        key: 'map-emergency',
        size: 14,
        data: points,
      })
    }
  )

  return {
    handleMapComplete,
    selectArea,
    handleZoom,
  }
}
