import { GlobalStateProps } from './index'

export default {
  showLoading: false,
  curMapType: '3D', // 2D、3D
  curView: { name: '南京东路街道', type: 'street' }, // 当前屏幕（街道or工作站）
  curPointType: null, // 当前地图撒点类型（null默认全部，还有衣食住行等）
  checkedKeys: [
    'life',
    'yi',
    'shi',
    'zhu',
    'xing',
    'other',
    // 'old',
    // 'sign',
    // 'history',
    // 'water',
    // 'range',
    // 'community',
    // '非居',
    // '居住',
  ],
  viewOptions: [
    // 屏幕切换选项
    { name: '南京东路街道', type: 'street' },
    { name: '第一工作站', type: 'work1', id: '01001' },
    { name: '第二工作站', type: 'work2', id: '01002' },
    { name: '第三工作站', type: 'work3', id: '01003' },
    // { name: '来福士专题屏', type: 'lfs' },
    // {name: "振兴小区", type:   url: "/community?id=527635870583459840"}
    // {name: "威海路62弄", type:   url: "/community?id=527635870583459841"}
  ],
  showCommunityPoints: false, // 显示地图自带小区门牌幢、勾边点位
  communityOptions: [
    // 小区选项
    { name: '振兴小区', type: '527635870583459840' },
    // { name: '威海路62弄', type: '527635870583459841' },
  ],
  curTheme: 'manage', // 街道屏下当前主题（公共管理、公共服务、公共安全）
  zhenxing: {
    paths: [
      [-394.9643478722986, -682.7008812875049],
      [-392.71331797961386, -676.0304740664822],
      [-388.88512021905166, -669.9078381232936],
      [-381.1708469780052, -664.8890129814765],
      [-326.4453957302277, -658.5038602372127],
      [-304.60275764390985, -657.5571461042011],
      [-225.16351998939285, -654.7707473022369],
      [-219.35507738292432, -655.8352839365185],
      [-214.4437394352484, -657.6770356668969],
      [-209.1231233252662, -662.528428833225],
      [-206.0307994322851, -666.8341177831445],
      [-153.432354391645, -823.1866440298637],
      [-153.70313943842342, -829.8508500666092],
      [-155.41259923755138, -834.0573200680908],
      [-159.34001594655143, -838.5593798534603],
      [-164.15006788436364, -840.605770664992],
      [-322.5944602939818, -861.0696787803082],
      [-330.93505314704254, -859.6227357822555],
      [-337.9630619947269, -851.2986794206012],
      [-368.02640337140963, -789.8986868289493],
      [-382.76455133728894, -745.7689924497688],
      [-394.9147383980797, -686.646901549337],
      [-394.9643478722986, -682.7008812875049],
    ],
  },
  weihai: {
    paths: [
      [-195.08054152916526, -563.6474449384453],
      [-162.7258625619948, -623.3421118538208],
      [-133.68985071392945, -603.4838527362609],
      [-168.5456740063052, -546.0991269642052],
      [-195.08054152916526, -563.6474449384453],
    ],
  },
  workArea1: {
    workStation: {
      name: '第一',
      address: '武胜路481号',
      x: -136.67,
      y: -660.07,
    },
    id: '01001',
    center: [57.65912693980181, -545.9925561181099],
    paths: [
      [-448.329953822261, -293.460812442785],
      [-431.7521211874291, -671.2658974800385],
      [-424.4347237401342, -721.1895650357069],
      [-398.89824688593046, -803.6322429418965],
      [-365.2547551197802, -867.1158334507442],
      [-392.5813071687177, -874.8011678318296],
      [-403.0902474574316, -1077.6749785273678],
      [-353.7288206095779, -1071.1265279304666],
      [-235.53838240578477, -1022.8565095154296],
      [-110.56798272540209, -1153.1351229372399],
      [-93.69249324525651, -1138.2894877772196],
      [-68.09400454827903, -1119.6983373136686],
      [108.32141989715319, -1078.5720831861604],
      [162.94558513506695, -1051.8780519335146],
      [319.4097326987787, -1005.952081175323],
      [764.5059353911838, -763.8371763725968],
      [632.5075268631167, -531.321704831237],
      [456.02595645205906, -245.14531867638112],
      [265.6661356282508, 118.08284918620457],
      [171.38332987513922, 95.29556402830092],
      [107.25481620144524, 61.96213147601915],
      [43.56451955001853, 9.376088803933783],
      [6.621997748308331, -34.25957789448293],
      [-61.673711759777404, 39.489039654835494],
      [-84.91161630850314, 43.66450373493032],
      [-117.17844516507756, 35.95023049388385],
      [-268.3674519701745, -19.099749397742613],
      [-336.6383567411507, -44.7065063404232],
      [-412.38375562778185, -44.284825809562136],
      [-452.45167430528585, -55.794223828358156],
      [-462.21647248071554, -56.90216875258136],
      [-480.70426987297697, -84.93978993199039],
      [-448.329953822261, -293.460812442785],
    ],
  },
  workArea2: {
    workStation: {
      name: '第二',
      address: '',
      x: 382.4793321452691,
      y: 678.9654976442117,
    },
    id: '01002',
    center: [494.2089963530598, 170.15832727829968],
    paths: [
      [62.564369398678764, 740.5887328698475],
      [137.63177213765096, 581.9293660719472],
      [265.9218724678516, 118.00636791345084],
      [455.7203121603603, -245.26520837748734],
      [636.8424354723139, -539.6788343141142],
      [1009.9399620665309, -314.1334937621058],
      [1093.7138275309285, -280.9447555096293],
      [964.1008078882224, 10.568783246614885],
      [884.0476529902461, -20.486747614446926],
      [826.2691520165776, 82.29581472151119],
      [899.6994421063242, 120.57779232713301],
      [826.2278107880617, 251.71216917922004],
      [705.7015931731263, 615.2007867814553],
      [689.5206363320461, 675.2447870777893],
      [684.3364462761659, 756.2487902316288],
      [534.3504692208784, 845.4714296144077],
      [483.33539323239313, 867.770888275825],
      [418.098934634476, 876.5269604754694],
      [339.3025530833796, 879.3795052430589],
      [278.7872627819655, 867.1094286195723],
      [216.4694949172632, 843.7681709995571],
      [158.20316744710817, 810.0089237935626],
      [69.50142754362844, 745.9134831026813],
      [62.564369398678764, 740.5887328698475],
    ],
  },
  workArea3: {
    workStation: {
      name: '第三',
      address: '',
      x: -57.84609277641425,
      y: 261.561716873108,
    },
    center: [59.44810057514178, 386.009149840996],
    id: '01003',
    paths: [
      [-827.6197677404292, 863.6615701613555],
      [-708.507420140734, 529.087007783064],
      [-544.6473267955473, 184.59055056098282],
      [-523.8857618349174, 124.25716166503844],
      [-480.70426987297697, -84.93978993199039],
      [-462.21647248071554, -56.90216875258136],
      [-452.45167430528585, -55.794223828358156],
      [-412.38375562778185, -44.284825809562136],
      [-336.6383567411507, -44.7065063404232],
      [-268.3674519701745, -19.099749397742613],
      [-117.17844516507756, 35.95023049388385],
      [-84.91161630850314, 43.66450373493032],
      [-61.673711759777404, 39.489039654835494],
      [6.621997748308331, -34.25957789448293],
      [43.56451955001853, 9.376088803933783],
      [107.25481620144524, 61.96213147601915],
      [171.38332987513922, 95.29556402830092],
      [265.6661356282508, 118.08284918620457],
      [171.40755583505143, 467.1165062378942],
      [134.7709591243579, 587.717138064158],
      [81.23406819640945, 702.8193864978215],
      [60.116968670543656, 737.5046772225696],
      [-52.52134254357884, 666.753298740646],
      [-117.37746183915078, 641.493808117498],
      [-151.4095611533494, 632.9609785518389],
      [-186.334631003489, 628.7524414889315],
      [-237.86233822557006, 637.5911961456075],
      [-301.7758775109821, 657.7822521527194],
      [-467.37230245383194, 765.9722471785428],
      [-527.2261330989933, 795.6221762700677],
      [-676.0132145273228, 855.6165670921827],
      [-733.4857904099746, 866.563724403164],
      [-791.5950212117696, 868.8044189887198],
      [-827.6197677404292, 863.6615701613555],
    ],
  },
  propertySummary: {},
  stationInfo: {},
  pubulicSafeGateSenteryShehuiwuye: [],
  pubulicSafeGateSenteryZhiguangongfang: [],
  pubulicSafeMap: [],
  pubulicSafeTruePeople: {},
  pubulicSafeHouse: {},
  pubulicSafeNonResident: {},
  pubulicSafeHouseStKind: {},
  pubulicSafeTrueCompany: {},
  pubulicSafeEmergencySupplies: {},
  pubulicSafeBuildings: [],
  pubulicSafePieData: [],
  pubulicSafeNewFindNum: {},
  pubulicSafeOutHouseWall: [],
  pubulicLeftCommandSystem: {},
  pubulicLeftStreetPower: [],
  pubulicLeftParty: {},
  pubulicLeftEconomic: {},
  communityInfo: {},
  issueData: [],
  scoreIssue: [],
  combineData: { cleanList: [], securityList: [], orderlyList: [] },
  dutySum: {},
  dutyList: [],
  dutyRank: { day: [], week: [], month: [] },
  dutyEvents: { day: [], week: [], month: [] },
  dutyPlaces: { day: [], week: [], month: [] },
  dutyRanking: { day: [], week: [], month: [] },
  yousubidaRank: {},
  classificationRank: [],
  urgentCase: [],
  todayCase: {},
  stageCase: {},
  workstationKind: [],
  workstationKindPiEData: {},
  trackEvent: [],
  analysisRank: { day: [], week: [], month: [] },
  moreHappenAddr: { day: [], week: [], month: [] },
  ecologyList: [],
  ecologyPoints: [],
  ecologyConvenient: [],
  ecologyPhoto: [],
  oldService: [],
  lifeConvenient: [],
  elevCount: [],
  responsivity: [],
  entry: [],
  emergencyPoints: [],
  beautyStreet: [],
  beautyHome: [],
  facilityConvenient: {},
  buildingPoints: [] as any,
  communityPaths: [] as any,
} as GlobalStateProps
