import { App, Plugin } from 'vue'
import dayjs from 'dayjs'
import ch from 'dayjs/locale/zh-cn'
import LocalizedFormat from 'dayjs/plugin/LocalizedFormat'
dayjs.extend(LocalizedFormat)
dayjs.locale(ch)

export const withInstall = <T>(comp: T) => {
  const c = comp as any
  c.install = function (app: App) {
    app.component(c.displayName || c.name, comp)
  }
  return comp as T & Plugin
}

export const getDate = (): string => dayjs().format('YYYY-MM-DD')
export const getTime = (): string => dayjs().format('dddd LTS')
