import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import vueJsx from '@vitejs/plugin-vue-jsx'
import { resolve } from 'path'

export default defineConfig({
  plugins: [vue(), vueJsx()],
  resolve: {
    alias: {
      '@': resolve(__dirname, './src'),
      '/@': resolve(__dirname, './src'),
    },
  },
  base: './',
  server: {
    port: 3002,
    proxy: {
      '/api': {
        target: 'http://nandong-dev.omniview.pro/nd-api',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, ''),
      },
    },
  },
})
