import axios, { AxiosRequestConfig, AxiosPromise } from 'axios'
import qs from 'qs'
import api from './api'
import store from '@/store'

const Axios = axios.create({
  baseURL: api.BASE_URL,
  timeout: 15000,
})
Axios.interceptors.request.use(
  (config) => {
    // 添加token
    config.headers.Authorization =
      'bearer eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX2lkIjoiMCIsImVuYWJsZSI6dHJ1ZSwic2NvcGUiOlsicmVhZCIsIndyaXRlIiwidHJ1c3QiXSwiZXhwIjoxNjMyNDc4MjczLCJqdGkiOiJiNWJlNjVhMS0xOTZmLTQ0MWQtYWUxYy1hNjFhMTM3YTE1ZmYiLCJjbGllbnRfaWQiOiJzc28iLCJ0aW1lc3RhbXAiOjE2MzI0NzEwNzMwNTh9.BppOUuGxmYTgAPr2XloyhaxrKI49_loj901RPLyizu9wEgVr40CpBGOcTDSy4LlYAwcRYCcRxm6xYBW5TNm5jH5iljHRi796CRnO6kyQUycnwdog4J-J3n_vkVPTqOg-CfO6KThnbrqkksxI14Lv8sYQXcT03ypMQlwC-_P56WK7h2N50dS4O-RY1P2iElzZcaDq_Q5icx2hsWeyPDDpSDYcyRIp5dVgBQLjqf0clH_FK2o4N7c6vnkC5Se6VTGbBRBCkhEi9JM0FkcpP8Fj-VbXBYO4HPQ-1ddiMRdxRx-nPT69lOTA_iGJteHruAA9EK2kFDHLsGdbiW2vB5WBlQ'
    return config
  },
  (error) => {
    return Promise.reject(error)
  }
)

Axios.interceptors.response.use(
  (response) => {
    if (response.config.headers.__show_loading) {
      store.commit('SET_LOADING', false)
    }

    // TODO 返回的数据status判断错误操作等……
    return response.data
  },
  (error) => {
    store.commit('SET_LOADING', false)
    return Promise.reject(error)
  }
)

interface ParamsProp {
  [propName: string]: unknown
}

interface RequestOptions {
  method?:
    | 'GET'
    | 'get'
    | 'delete'
    | 'DELETE'
    | 'head'
    | 'HEAD'
    | 'options'
    | 'OPTIONS'
    | 'post'
    | 'POST'
    | 'put'
    | 'PUT'
    | 'patch'
    | 'PATCH'
    | 'purge'
    | 'PURGE'
    | 'link'
    | 'LINK'
    | 'unlink'
    | 'UNLINK'
    | undefined
  url: string
  params?: ParamsProp
  contentType?:
    | 'application/json;charset=UTF-8'
    | 'application/x-www-form-urlencoded;charset=UTF-8'
  showLoading?: boolean
  headers?: { [key: string]: string }
}

/**
 * 请求
 * @param {String} method [请求方法]
 * @param {String} url [请求地址]
 * @param {Object} params [请求参数]
 * @param {String} contentType [请求头，默认为'application/json;charset=UTF-8']
 * @param {Boolean} showLoading [是否显示请求时的loading图，默认为true]
 */
const ajax = ({
  method = 'GET',
  url,
  params = {},
  contentType = 'application/json;charset=UTF-8',
  showLoading = true,
  headers = {},
}: RequestOptions) => {
  if (!url || typeof url != 'string') {
    throw new Error('接口URL不正确')
  }
  let config: AxiosRequestConfig = {
    method,
    url,
    headers: {
      'X-Requested-With': 'XMLHttpRequest',
      'Content-Type': contentType,
      'Access-Control-Allow-Origin': '*',
      'Access-Control-Allow-Headers':
        'Authorization,Origin, X-Requested-With, Content-Type, Accept',
      'Access-Control-Allow-Methods': '*',
      __show_loading: showLoading,
      ...headers,
    },
  }
  if (method === 'GET') {
    config = Object.assign(config, { params })
  } else {
    if (contentType.toLowerCase().indexOf('x-www-form-urlencoded') >= 0) {
      config = Object.assign(config, { data: qs.stringify(params) })
    } else {
      config = Object.assign(config, { data: params })
    }
  }
  if (showLoading) {
    store.commit('SET_LOADING', true)
  }
  return Axios(config)
}

export default {
  get(args: RequestOptions): AxiosPromise<any> {
    return ajax({ method: 'GET', ...args })
  },
  post(args: RequestOptions): AxiosPromise<any> {
    // args.contentType = 'application/x-www-form-urlencoded;charset=UTF-8'
    return ajax({ method: 'POST', ...args })
  },
  put(args: RequestOptions): AxiosPromise<any> {
    return ajax({ method: 'PUT', ...args })
  },
  delete(args: RequestOptions): AxiosPromise<any> {
    return ajax({ method: 'DELETE', ...args })
  },
}
