let BASE_URL = ''
let SOURCE_URL = ''
switch (process.env.NODE_ENV) {
  case 'production':
    // 政务网生产环境，设置了代理api
    BASE_URL = '/nd-api'
    SOURCE_URL = 'http://10.81.71.243:23456/nd-file/'
    break
  case 'test':
    // 普通打包（测试用）
    BASE_URL = 'http://nandong-dev.omniview.pro/api'
    SOURCE_URL = 'http://zhongbang.omniview.pro/'
    break
  default:
    // 开发环境
    BASE_URL = '/api'
    SOURCE_URL = 'http://zhongbang.omniview.pro/'
}

export default {
  BASE_URL,
  SOURCE_URL,
  TEST: '/service-basicdatasync-ddd/communities',
  GET_LIST: '/service-special-nandong/classifyAddrs', // 根据地址搜索
  GET_ROOM: '/service-special-nandong/households', // 获取分户
  GET_PERSON: '/service-special-nandong/personnels', // 实有人口
  GET_COMMUNITY: '/service-basicdatasync-ddd/communities',
  GET_MANAGE: '/service-basicdatasync-ddd/css', // 小区管理处
  GET_BUILDING: '/service-basicdatasync-ddd/building', // 门牌幢列表
  GET_DEVICE: '/service-basicdatasync-ddd/facilitiesEquipment', // 设施设备列表
  GET_INDUSTRY_AUTHORITY: '/service-basicdatasync-ddd/indCous', // 业委会列表
  GET_HOC_MEMBER: '/service-basicdatasync-ddd/indcou/members', // 业委会成员
  GET_COMMITTEE: '/service-basicdatasync-ddd/residentsCommittees', // 居委会列表
  GET_COMPANY: '/service-basicdatasync-ddd/propCompanies', // 物业列表
  GET_CASE: '/service-special-nandong/compairs', // 案件汇总列表
  GET_CASE_DETAIL: '/service-special-nandong/compair', // 案件详情

  GET_FOR_OLD: '/service-special-nandong/forOldFacilitiess', // 为老
  GET_MARKETS: '/service-special-nandong/vegetableMarkets', // 菜场、药店、便利店
  GET_DUNGS: '/service-special-nandong/urDungs', // 倒粪口
  GET_BINS: '/service-special-nandong/internalDustbins', // 垃圾箱

  GET_PUBLICSAFE_RIGHT_GATE: '/service-special-nandong/ironGate/statistical', // 公共安全-右侧-门岗分布
  GET_PUBLICSAFE_RIGHT_SAFEMAP: '/service-special-nandong/peaceMaps', // 公共安全-右侧-平安地图
  GET_PUBLICSAFE_TRUE_PEOPLE: '/service-special-nandong/personnel/statistical', // 公共安全-右侧-实有人口
  GET_PUBLICSAFE_HOUSE: '/service-basicdatasync-ddd/resource/count', // 公共安全-右侧-居住房屋
  GET_PUBLICSAFE_NONRESIDENT:
    '/service-basicdatasync-ddd/nonResident/statistical', // 公共安全-右侧-非居房屋
  GET_PUBLICSAFE_TRUE_COMPANY: '/service-special-nandong/company/statistical', // 公共安全-右侧-实有单位
  GET_PUBLICSAFE_SOS_MATERIAL: '/service-special-nandong/emergencySupplies', // 公共安全-右侧-应急物资储备
  GET_PUBLICSAFE_OUTHOUSEWALL:
    '/service-special-nandong/inspection/statistical', // 公共安全-右侧-房屋外立面
  GET_PUBLICSAFE_BUILDINGS: '/service-special-nandong/inspections', // 公共安全-右侧-重点关注楼宇
  GET_PUBLICSAFE_PIEDATA: '/service-special-nandong/inspection/getPie', // 公共安全-右侧-房屋外立面饼图
  GET_PUBLICSAFE_NEWFIND: '/service-special-nandong/noAlert', // 公共安全-右侧-最新发现

  // 左侧公共
  GET_PUBLICSAFE_COMMANDSYSTEM: '/service-special-nandong/commandSystem', // 指挥体系
  GET_PUBLICSAFE_STREETPOWER: '/service-special-nandong/workstations', // 网格工作站(原名街道力量)
  GET_PUBLICSAFE_PARTY: '/service-special-nandong/partyConstruction/1', // 党建
  GET_PUBLICSAFE_ECONOMIC: '/service-special-nandong/economic', // 经济

  /** 小区屏 */
  GET_COMMUNITY_IDS: '/service-special-nandong/getSectIdList', // 获取小区id列表
  GET_COMMUNITY_INFO: '/service-special-nandong/bigscreenCommunity/statistical', // 小区档案
  GET_COMMUNITY_FACILITY: '/service-special-nandong/communityRelations', // 小区设施
  GET_ISSUE_LIST: '/service-special-nandong/management/factors', // 管理要素列表
  GET_SCORE_ISSUE: '/service-special-nandong/score/elements', // 评分要素
  GET_COMBINE_LIST: '/service-special-nandong/league/linkage', // 联勤联动列表

  /** 报警发短信 */
  POST_ALARM: '/service-alarm-nandong/public/alarm',

  /** 工作站 */
  GET_STATION: '/service-special-nandong/workstations', // 工作站信息
  GET_DUTY_SUM: '/service-special-nandong/workStation/dutyNum', // 勤务统计数
  GET_DUTY_LIST: '/service-special-nandong/workStation/dutyList', // 勤务列表
  GET_DUTY_RANK: '/service-special-nandong/compair/getRanking', // 勤务分析 - 事件类型
  GET_DUTY_EVENTS: '/service-special-nandong/compair/getRanking/cmt', // 勤务分析 - 居委事件数量
  GET_DUTY_PLACES: '/service-special-nandong/compair/getRanking/addr', // 勤务分析 - 多发地点
  GET_DUTY_RANKING: '/service-special-nandong/compair/getRanking/all', // 勤务分析 - 排行
  GET_OLD_SERVICE: '/service-special-nandong/forOld/statistics', // 便民 - 为老
  GET_LIFE_CONVENIENT: '/service-special-nandong/convenient/statistics', // 便民 - 生活便利

  /** 公共管理 */
  GET_YOUSUBIDA_RANK: '/service-special-nandong/compair/willReach', // 有诉必答-占比
  GET_YOUSUBIDA_CLASSIFICATION_RANK:
    '/service-special-nandong/compair/willReach/ranking', // 有诉必答-分类排行
  GET_URGENTCASE: '/service-special-nandong/compairs', //  有诉必答-紧急案件
  GET_TODAYCASE: '/service-special-nandong/compair/willTouch', //  有求必应-今日案件数
  GET_STAGECASE: '/service-special-nandong/compair/willTouch/status', // 有求必应-各阶段案件数
  GET_WORKSTATION: '/service-special-nandong/compair/willTouch/workStation', // 有求必应-工作站分类
  GET_TRACKEVENT: '/service-special-nandong/compairs', // 有求必应-事件跟踪
  GET_CASE_CLASSIFICATION_RANK: '/service-special-nandong/compair/analysis', // 案件分析-分类排行
  GET_MOREHAPPEN_ADDR: '/service-special-nandong/compair/analysis/addr', // 案件分析-多发地点
  GET_RESPONSIVITY: '/service-special-nandong/compair/responsivity', // 响应度
  GET_ENTRY: '/service-special-nandong/inputUrl', // 业务入口

  /** 公共服务 */
  GET_ECOLOGY_LIST: '/service-special-nandong/nonResident/ecological', // 生态-衣食住行
  GET_ECOLOGY_POINTS: '/service-basicdatasync-ddd/nonResidents', // 获取衣食住行撒点
  GET_ECOLOGY_CONVENIENT: '/service-special-nandong/convenient/ecological', // 生态-便民设施
  GET_ECOLOGY_PHOTO: '/service-special-nandong/buildingPhotos', // 生态 - 商业综合体、文保、历保照片
  GET_ELEV_COUNT: '/service-special-nandong/elevatorAdd/workstation', // 美丽家园-电梯加装统计数字
  GET_ELEV_LIST: '/service-special-nandong/elevatorAdds', // 美丽家园 - 根据名称查询列表
  GET_TOILET: '/service-special-nandong/toiletRenovations', // 马桶改造

  GET_BEAUTY_STREET: '/service-special-nandong/beautifulStreets', // 美丽街区
  GET_BEAUTY_HOME: '/service-special-nandong/beautifulHomes', // 美丽家园
  GET_EVENTS: '/service-special-nandong/compairs', // 事件
}
