import Vue from 'vue'
import Router from 'vue-router'

// const Main = () => import('@/views/project-management/main')
// const ChinaMap = () => import('@/views/china')
// const MapTest = () => import('@/views/map-test')
const GDEnterprise = () => import('@/views/guangdong/gd-enterprise') // 广东 - 企业专题
const GDProduction = () => import('@/views/guangdong/gd-production') // 广东 - 生产专题
const GDTrade = () => import('@/views/guangdong/gd-trade') // 广东 - 交易专题
const GDDisease = () => import('@/views/guangdong/gd-disease') // 广东 - 疫病专题
const GDFish = () => import('@/views/guangdong/gd-fish') // 广发 - 罗非鱼专题
const GDIndustry = () => import('@/views/guangdong/gd-industry') // 广东 - 产业分析专题
const Map3D = () => import('@/views/3d-map') // 浦东 - 街镇电梯地图

Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      redirect: '/industry'
    },
    {
      path: '/production',
      name: 'production',
      component: GDProduction
    },
    {
      path: '/trade',
      name: 'trade',
      component: GDTrade
    },
    {
      path: '/disease',
      name: 'disease',
      component: GDDisease
    },
    {
      path: '/fish',
      name: 'fish',
      component: GDFish
    },
    {
      path: '/industry',
      name: 'industry',
      component: GDIndustry
    },
    {
      path: '/enterprise',
      name: 'enterprise',
      component: GDEnterprise
    },
    {
      path: '/map3d',
      name: 'map3d',
      component: Map3D
    },
    // {
    //   path: '/main',
    //   name: 'main',
    //   component: Main
    // },
    // {
    //   path: '/map',
    //   name: 'map',
    //   component: ChinaMap
    // },
    // {
    //   path: '/map2',
    //   name: 'map2',
    //   component: MapTest
    // },
  ]
})
