# 动态组件库

## Dev

1. 执行命令`npm install`安装依赖

2. 执行命令`npm run serve`启动本地服务进行开发

## Build

1. 执行命令`npm run build:unpkg`进行打包;

2. 将打包后的文件`/dist/component-lib.min.js`放置在服务器上;

3. 在大屏项目中引入使用：

```javascript
import * as vue from 'vue'
import fetchComponents from 'http://127.0.0.1:8080/component-lib.min.js' // 假设打包文件放在http://127.0.0.1:8080上

// 需要和大屏共用一个vue，因此将vue作为参数传入
// 第二个参数为请求数据地址
const { components, eventBus } = fetchComponents(vue)('http://127.0.0.1:8082')

export default components // 暴露出组件
export const bus = eventBus // 暴露出组件的事件总线
```
