import { ref } from 'vue'
import bus from '@/util/event-bus'

export default function usePointType() {
  const curPointType = ref<number>(0)
  bus.on('curPointType', (key: unknown | number) => {
    if (typeof key === 'number') {
      curPointType.value = key
    }
  })
  const setCurPointType = (key: number | unknown = 0) => {
    bus.emit('curPointType', key)
  }
  return { curPointType, setCurPointType }
}
